/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.component.salesforce.api.dto.AbstractDescribedSObjectBase;
import org.apache.camel.component.salesforce.api.dto.Attributes;
import org.apache.camel.component.salesforce.api.dto.CreateSObjectResult;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.Limits;
import org.apache.camel.component.salesforce.api.dto.RecentItem;
import org.apache.camel.component.salesforce.api.dto.SObjectBasicInfo;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.Version;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.api.dto.bulk.JobInfo;
import org.apache.camel.component.salesforce.api.dto.bulk.OperationEnum;
import org.apache.camel.component.salesforce.api.utils.QueryHelper;
import org.apache.camel.component.salesforce.internal.dto.PushTopic;
import org.apache.camel.component.salesforce.internal.dto.QueryRecordsPushTopic;
import org.apache.camel.quarkus.component.salesforce.generated.Account;
import org.apache.camel.quarkus.component.salesforce.generated.QueryRecordsAccount;
import org.apache.camel.quarkus.component.salesforce.model.GlobalObjectsAndHeaders;
import org.apache.camel.spi.RouteController;

@Path(value="/salesforce")
public class SalesforceResource {
    @Inject
    FluentProducerTemplate template;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/document/{id}")
    @GET
    @Produces(value={"application/json"})
    public String getDocument(@PathParam(value="id") String id) {
        return (String)this.template.withBody((Object)id).withHeader("sObjectIdName", (Object)"Name").withHeader("sObjectName", (Object)"Document").to("salesforce:getSObjectWithId?rawPayload=true").request(String.class);
    }

    @Path(value="/account/query/{id}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject getAccountByQueryRecords(@PathParam(value="id") String accountId) {
        String query = QueryHelper.queryToFetchFilteredFieldsOf((AbstractDescribedSObjectBase)new Account(), sObjectField -> sObjectField.getName().equals("Id") || sObjectField.getName().equals("AccountNumber"));
        QueryRecordsAccount request = (QueryRecordsAccount)((Object)this.template.toF("salesforce:query?sObjectQuery=%s&sObjectClass=%s", new Object[]{query + " WHERE Id = '" + accountId + "'", QueryRecordsAccount.class.getName()}).request(QueryRecordsAccount.class));
        return this.accountToJsonObject(request.getRecords().get(0));
    }

    @Path(value="/account")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public String createAccount(String accountName) {
        Account account = new Account();
        account.setName(accountName);
        account.setAccountNumber(UUID.randomUUID().toString());
        CreateSObjectResult result = (CreateSObjectResult)this.template.to("salesforce:createSObject?sObjectName=Account").withBody((Object)account).request(CreateSObjectResult.class);
        return result.getId();
    }

    @Path(value="/account/{id}")
    @DELETE
    public Response deleteAccount(@PathParam(value="id") String accountId) {
        Account account = new Account();
        account.setId(accountId);
        this.template.to("salesforce:deleteSObject").withBody((Object)account).send();
        return Response.noContent().build();
    }

    @Path(value="/account/{id}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject getAccountById(@PathParam(value="id") String accountId) {
        Account account = (Account)((Object)this.template.to("salesforce:getSObjectWithId?sObjectName=Account&sObjectIdName=Id&sObjectClass=" + Account.class.getName()).withBody((Object)accountId).request(Account.class));
        return this.accountToJsonObject(account);
    }

    @Path(value="/bulk")
    @POST
    @Produces(value={"application/json"})
    public JsonObject createJob() {
        JobInfo jobInfo = this.createJobInfo();
        jobInfo.setOperation(OperationEnum.INSERT);
        JobInfo result = (JobInfo)this.template.to("salesforce:createJob").withBody((Object)jobInfo).request(JobInfo.class);
        return this.jobInfoToJsonObject(result);
    }

    @Path(value="/bulk")
    @DELETE
    @Produces(value={"application/json"})
    public JsonObject abortJob(@QueryParam(value="jobId") String jobId) {
        JobInfo jobInfo = this.createJobInfo();
        jobInfo.setId(jobId);
        JobInfo result = (JobInfo)this.template.to("salesforce:abortJob").withBody((Object)jobInfo).request(JobInfo.class);
        return this.jobInfoToJsonObject(result);
    }

    @Path(value="/cdc/{action}")
    @POST
    public Response modifyCdcConsumerState(@PathParam(value="action") String action) throws Exception {
        RouteController controller = this.context.getRouteController();
        if (action.equals("start")) {
            controller.startRoute("cdc");
        } else if (action.equals("stop")) {
            controller.stopRoute("cdc");
        } else {
            throw new IllegalArgumentException("Unknown action: " + action);
        }
        return Response.ok().build();
    }

    @Path(value="/cdc")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> getCdcEvents() {
        return (Map)this.consumerTemplate.receiveBody("seda:events", 10000L, Map.class);
    }

    @Path(value="sobjects/force-limit")
    @GET
    @Produces(value={"application/json"})
    public String getSObjectsWithForceLimitInfo() {
        Exchange exchange = this.template.to("salesforce:getGlobalObjects").withHeader("Sforce-Limit-Info", Collections.singletonList("api-usage")).send();
        GlobalObjectsAndHeaders objectsAndHeaders = new GlobalObjectsAndHeaders((GlobalObjects)exchange.getMessage().getBody(GlobalObjects.class)).withHeader("Sforce-Limit-Info", (String)exchange.getMessage().getHeader("Sforce-Limit-Info", String.class));
        return objectsAndHeaders.getHeader("Sforce-Limit-Info");
    }

    @Path(value="versions")
    @GET
    @Produces(value={"application/json"})
    public List<String> getListVersions() {
        List versions = (List)this.template.to("salesforce:getVersions").request(List.class);
        return versions.stream().map(Version::getVersion).collect(Collectors.toList());
    }

    @Path(value="resources")
    @GET
    @Produces(value={"application/json"})
    public Map<String, String> getListResources() {
        return (Map)this.template.to("salesforce:getResources").request(Map.class);
    }

    @Path(value="basic-info/account")
    @GET
    public JsonObject getAccountBasicInfo() {
        SObjectBasicInfo basicInfo = (SObjectBasicInfo)this.template.to("salesforce:getBasicInfo?sObjectName=Account").request(SObjectBasicInfo.class);
        return this.basicInfoToJsonObject(basicInfo);
    }

    @Path(value="describe/account")
    @GET
    public String getAccountDescription() {
        SObjectDescription sObjectDescription = (SObjectDescription)this.template.to("salesforce:getDescription?sObjectName=Account").request(SObjectDescription.class);
        return sObjectDescription.getName();
    }

    @Path(value="limits")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Integer> getLimits() {
        Limits limits = (Limits)this.template.to("salesforce:limits").request(Limits.class);
        HashMap<String, Integer> limitInfo = new HashMap<String, Integer>();
        for (Limits.Operation operation : Limits.Operation.values()) {
            Limits.Usage usage = limits.forOperation(operation.name());
            limitInfo.put(operation.name(), usage.getRemaining());
        }
        return limitInfo;
    }

    @Path(value="streaming")
    @GET
    @Produces(value={"application/json"})
    public String getSubscribedObjects() {
        Account account = (Account)((Object)this.consumerTemplate.receiveBody("seda:CamelTestTopic", 10000L, Account.class));
        return account.getName();
    }

    @Path(value="streaming/raw")
    @GET
    @Produces(value={"application/json"})
    public String getRawSubscribedObjects() {
        return (String)this.consumerTemplate.receiveBody("seda:RawPayloadCamelTestTopic", 10000L, String.class);
    }

    @Path(value="/topic/{id}")
    @DELETE
    public Response deleteTopic(@PathParam(value="id") String topicId) {
        PushTopic topic = new PushTopic();
        topic.setId(topicId);
        this.template.to("salesforce:deleteSObject").withBody((Object)topic).send();
        return Response.noContent().build();
    }

    @Path(value="/topic")
    @GET
    public String getTopicId() {
        QueryRecordsPushTopic queryRecordsPushTopic = (QueryRecordsPushTopic)this.template.to("salesforce:query?sObjectQuery=SELECT Id FROM PushTopic WHERE Name = 'CamelTestTopic'&sObjectClass=" + QueryRecordsPushTopic.class.getName()).request(QueryRecordsPushTopic.class);
        return ((PushTopic)queryRecordsPushTopic.getRecords().get(0)).getId();
    }

    @Path(value="platform/event")
    @GET
    @Produces(value={"application/json"})
    public String getPlatformEvent() {
        return (String)this.consumerTemplate.receiveBody("salesforce:event/TestEvent__e?rawPayload=true", 10000L, String.class);
    }

    private JsonObject accountToJsonObject(Account account) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Id", account.getId());
        builder.add("AccountNumber", account.getAccountNumber());
        return builder.build();
    }

    private JobInfo createJobInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setObject(Account.class.getSimpleName());
        jobInfo.setContentType(ContentType.CSV);
        return jobInfo;
    }

    private JsonObject jobInfoToJsonObject(JobInfo jobInfo) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("id", jobInfo.getId());
        objectBuilder.add("state", jobInfo.getState().value().toUpperCase(Locale.US));
        return objectBuilder.build();
    }

    private JsonObject basicInfoToJsonObject(SObjectBasicInfo basicInfo) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        List recentItems = basicInfo.getRecentItems();
        JsonArrayBuilder recentItemsArrayBuilder = Json.createArrayBuilder();
        for (RecentItem recentItem : recentItems) {
            JsonObjectBuilder recentItemBuilder = Json.createObjectBuilder();
            recentItemBuilder.add("Id", recentItem.getId());
            recentItemBuilder.add("Name", recentItem.getName());
            Attributes attributes = recentItem.getAttributes();
            JsonObjectBuilder attributesObjectBuilder = Json.createObjectBuilder();
            attributesObjectBuilder.add("url", attributes.getUrl());
            recentItemBuilder.add("attributes", attributesObjectBuilder);
            recentItemsArrayBuilder.add(recentItemBuilder);
        }
        builder.add("recentItems", recentItemsArrayBuilder);
        return builder.build();
    }
}

