/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.component.salesforce.api.dto.RestResources;
import org.apache.camel.component.salesforce.api.dto.SObjectBasicInfo;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.quarkus.component.salesforce.SalesforceTestResource;
import org.apache.camel.quarkus.component.salesforce.model.GlobalObjectsAndHeaders;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=SalesforceTestResource.class)
class SalesforceTest {
    SalesforceTest() {
    }

    @Test
    public void testGetDocumentRaw() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/salesforce/document/test", (Object[])new Object[0]).then()).statusCode(200)).body("attributes.type", Matchers.is((Object)"Document"), new Object[0]);
    }

    @Test
    public void testGetAccountDTO() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/salesforce/account", (Object[])new Object[0]).then()).statusCode(200)).body("Id", IsNot.not((Matcher)Matchers.emptyString()), new Object[]{"AccountNumber", IsNot.not((Matcher)Matchers.emptyString())});
    }

    @Test
    public void testGetAccountByQueryHelper() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/salesforce/account/query", (Object[])new Object[0]).then()).statusCode(200)).body("Id", IsNot.not((Matcher)Matchers.emptyString()), new Object[]{"AccountNumber", IsNot.not((Matcher)Matchers.emptyString())});
    }

    @Test
    public void testBulkJobApi() {
        JsonPath jobInfo = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().post("/salesforce/bulk", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        String id = jobInfo.getString("id");
        String state = jobInfo.getString("state");
        Assertions.assertNotNull((Object)id);
        Assertions.assertTrue((id.length() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"OPEN", (Object)state);
        jobInfo = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("jobId", new Object[]{id}).delete("/salesforce/bulk", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        state = jobInfo.getString("state");
        Assertions.assertEquals((Object)"ABORTED", (Object)state);
    }

    @Test
    void testGlobalObjectsWithHeaders() {
        GlobalObjectsAndHeaders globalObjectsAndHeaders = (GlobalObjectsAndHeaders)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/sobjects/force-limit", new Object[0])).then()).statusCode(200)).extract().body().as(GlobalObjectsAndHeaders.class);
        Assertions.assertNotNull((Object)globalObjectsAndHeaders);
        Assertions.assertNotNull((Object)globalObjectsAndHeaders.getGlobalObjects());
        Assertions.assertTrue((boolean)globalObjectsAndHeaders.getHeader("Sforce-Limit-Info").contains("api-usage="));
    }

    @Test
    void testGetVersions() {
        List versions = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/versions", new Object[0])).then()).statusCode(200)).extract().body().as(List.class);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertNotEquals((int)0, (int)versions.size());
    }

    @Test
    void testGetRestResources() {
        RestResources restResources = (RestResources)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/resources", new Object[0])).then()).statusCode(200)).extract().body().as(RestResources.class);
        Assertions.assertNotNull((Object)restResources);
    }

    @Test
    void testAccountWithBasicInfo() {
        String accountName = "Camel Quarkus Account Test: " + UUID.randomUUID().toString();
        String accountId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(accountName).post("/salesforce/account", new Object[0])).then()).statusCode(200)).extract().body().asString();
        SObjectBasicInfo accountBasicInfo = (SObjectBasicInfo)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/basic-info/account", new Object[0])).then()).statusCode(200)).extract().body().as(SObjectBasicInfo.class);
        Assertions.assertNotNull((Object)accountBasicInfo);
        List recentItems = accountBasicInfo.getRecentItems();
        Assertions.assertNotNull((Object)recentItems);
        Assertions.assertTrue((boolean)recentItems.stream().anyMatch(recentItem -> recentItem.getAttributes().getUrl().contains(accountId)));
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(200)).body("Id", IsNot.not((Matcher)Matchers.emptyString()), new Object[]{"AccountNumber", IsNot.not((Matcher)Matchers.emptyString())});
        ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    void testGetAccountDescription() {
        SObjectDescription accountDescription = (SObjectDescription)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/describe/account", new Object[0])).then()).statusCode(200)).extract().body().as(SObjectDescription.class);
        Assertions.assertNotNull((Object)accountDescription);
    }

    @Test
    void testLimits() {
        Map limits = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/limits", new Object[0])).then()).statusCode(200)).extract().body().as(Map.class);
        Assertions.assertNotNull((Object)limits, (String)"Should fetch limits from Salesforce REST API");
        Assertions.assertNotNull(limits.get("concurrentAsyncGetReportInstances"));
        Assertions.assertNotNull(limits.get("concurrentSyncReportRuns"));
        Assertions.assertNotNull(limits.get("dailyApiRequests"));
        Assertions.assertNotNull(limits.get("dailyAsyncApexExecutions"));
        Assertions.assertNotNull(limits.get("dailyBulkApiRequests"));
    }
}

