/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.saga.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.quarkus.component.saga.it.CreditService;
import org.apache.camel.quarkus.component.saga.it.OrderManagerService;
import org.jboss.logging.Logger;

@Path(value="/saga")
@ApplicationScoped
public class SagaResource {
    private static final Logger LOG = Logger.getLogger(SagaResource.class);
    private static final String COMPONENT_SAGA = "saga";
    @Inject
    CamelContext context;
    @Inject
    OrderManagerService orderManagerService;
    @Inject
    CreditService creditService;

    @Path(value="/load/component/saga")
    @GET
    @Produces(value={"text/plain"})
    public Response loadComponentSaga() throws Exception {
        if (this.context.getComponent(COMPONENT_SAGA) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", (Object)COMPONENT_SAGA);
        return Response.status((int)500, (String)"saga could not be loaded from the Camel context").build();
    }

    @Path(value="/test")
    @GET
    @Produces(value={"text/plain"})
    public Response buy() {
        try {
            this.buy(20, false, false);
            this.buy(70, false, false);
            this.buy(20, false, true);
            this.buy(5, false, false);
            this.buy(1, true, true);
            Thread.sleep(500L);
            if (this.orderManagerService.getOrders().size() == 3 && this.creditService.getCredit() == 5) {
                return Response.ok().build();
            }
            return Response.status((int)500, (String)"not equal").build();
        }
        catch (Exception e) {
            return Response.status((int)500, (String)("saga is failed with " + e)).build();
        }
    }

    private void buy(int amount, boolean failAtTheEnd, boolean shouldFail) throws RuntimeException {
        block3: {
            try {
                this.context.createFluentProducerTemplate().to("direct:saga").withHeader("amount", (Object)amount).withHeader("fail", (Object)failAtTheEnd).request();
                if (shouldFail) {
                    throw new RuntimeException("Exception not thrown");
                }
            }
            catch (Exception ex) {
                if (shouldFail) break block3;
                throw new RuntimeException("Unexpected exception");
            }
        }
    }
}

