/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.saga.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SagaPropagation;
import org.apache.camel.quarkus.component.saga.it.CreditService;
import org.apache.camel.quarkus.component.saga.it.OrderManagerService;
import org.apache.camel.saga.InMemorySagaService;

@ApplicationScoped
public class SagaRoute
extends RouteBuilder {
    @Inject
    OrderManagerService orderManagerService;
    @Inject
    CreditService creditService;

    public void configure() throws Exception {
        InMemorySagaService sagaService = new InMemorySagaService();
        this.getContext().addService((Object)sagaService);
        ((SagaDefinition)((SagaDefinition)((SagaDefinition)((SagaDefinition)((SagaDefinition)((SagaDefinition)this.from("direct:saga").saga().propagation(SagaPropagation.REQUIRES_NEW).log("Creating a new order")).to("direct:newOrder")).log("Taking the credit")).to("direct:reserveCredit")).log("Finalizing")).to("direct:finalize")).log("Done!");
        ((SagaDefinition)((ProcessorDefinition)this.from("direct:newOrder").saga().propagation(SagaPropagation.MANDATORY).compensation("direct:cancelOrder").transform().header("Long-Running-Action")).bean((Object)this.orderManagerService, "newOrder")).log("Order ${body} created");
        ((RouteDefinition)((ProcessorDefinition)this.from("direct:cancelOrder").transform().header("Long-Running-Action")).bean((Object)this.orderManagerService, "cancelOrder")).log("Order ${body} cancelled");
        ((SagaDefinition)((ProcessorDefinition)this.from("direct:reserveCredit").saga().propagation(SagaPropagation.MANDATORY).compensation("direct:refundCredit").transform().header("Long-Running-Action")).bean((Object)this.creditService, "reserveCredit")).log("Credit ${header.amount} reserved in action ${body}");
        ((RouteDefinition)((ProcessorDefinition)this.from("direct:refundCredit").transform().header("Long-Running-Action")).bean((Object)this.creditService, "refundCredit")).log("Credit for action ${body} refunded");
        ((ChoiceDefinition)this.from("direct:finalize").saga().propagation(SagaPropagation.MANDATORY).choice().when(this.header("fail").isEqualTo((Object)true)).to("saga:COMPENSATE")).end();
    }
}

