/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.saga.it;

import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.apache.camel.Header;

@ApplicationScoped
@RegisterForReflection
public class CreditService {
    private int totalCredit = 100;
    private Map<String, Integer> reservations = new HashMap<String, Integer>();

    public synchronized void reserveCredit(String id, @Header(value="amount") int amount) {
        int credit = this.getCredit();
        if (amount > credit) {
            throw new IllegalStateException("Insufficient credit");
        }
        this.reservations.put(id, amount);
    }

    public synchronized void refundCredit(String id) {
        this.reservations.remove(id);
    }

    public synchronized int getCredit() {
        return this.totalCredit - this.reservations.values().stream().reduce(0, (a, b) -> a + b);
    }
}

