/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.rest.it.Person;

@Path(value="/rest")
@ApplicationScoped
public class RestResource {
    @Inject
    CamelContext camelContext;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/inspect/configuration")
    @GET
    @Produces(value={"application/json"})
    public JsonObject inspectConfiguration() {
        return Json.createObjectBuilder().add("component", this.camelContext.getRestConfiguration().getComponent()).build();
    }

    @Path(value="/invoke/route")
    @GET
    @Produces(value={"text/plain"})
    public String restProducer(@QueryParam(value="port") int port) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("messageStart", "Hello");
        headers.put("messageEnd", "Invoked");
        return (String)this.producerTemplate.requestBodyAndHeaders("rest:get:/rest/template/{messageStart}/{messageEnd}?host=localhost:" + port, null, headers, String.class);
    }

    @Path(value="/producer/binding/mode/json")
    @GET
    @Produces(value={"application/json"})
    public Person restProducerBindingModeJson(@QueryParam(value="port") int port) {
        String query = "rest:get:/rest/binding/json/producer?bindingMode=json&outType=org.apache.camel.quarkus.component.rest.it.Person&host=localhost:" + port;
        return (Person)this.producerTemplate.requestBody(query, null, Person.class);
    }

    @Path(value="/producer/binding/mode/xml")
    @GET
    @Produces(value={"application/json"})
    public Person restProducerBindingModeXml(@QueryParam(value="port") int port) {
        String query = "rest:get:/rest/binding/xml/producer?bindingMode=xml&outType=org.apache.camel.quarkus.component.rest.it.Person&host=localhost:" + port;
        return (Person)this.producerTemplate.requestBody(query, null, Person.class);
    }
}

