/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.it;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.quarkus.component.rest.it.Person;

public class RestRoutes
extends RouteBuilder {
    private static final String PERSON_JSON = "{\"firstName\": \"John\", \"lastName\": \"Doe\", \"age\": 64}";
    private static final String PERSON_XML = "<person firstName=\"John\" lastName=\"Doe\" age=\"64\"/>";

    public void configure() {
        this.restConfiguration().enableCORS(true).corsAllowCredentials(true).corsHeaderProperty("Access-Control-Allow-Methods", "GET, POST").endpointProperty("fileNameExtWhitelist", ".txt");
        this.rest("/rest").delete().produces("text/plain").to("seda:echoMethodPath").get().produces("text/plain").to("seda:echoMethodPath").head().to("seda:contentTypeText").patch().consumes("text/plain").produces("text/plain").to("seda:echoBodyPath").post().consumes("text/plain").produces("text/plain").to("seda:echoBodyPath").put().consumes("text/plain").produces("text/plain").to("seda:echoBodyPath").post("/validation").clientRequestValidation(true).param().name("messageStart").type(RestParamType.query).required(Boolean.valueOf(true)).endParam().param().name("messageMiddle").type(RestParamType.body).required(Boolean.valueOf(true)).endParam().param().name("messageEnd").type(RestParamType.header).required(Boolean.valueOf(true)).endParam().param().name("unused").type(RestParamType.formData).required(Boolean.valueOf(false)).endParam().to("direct:greetWithBody").get("/template/{messageStart}/{messageEnd}").to("direct:greet").post("/pojo/binding/json").bindingMode(RestBindingMode.json).type(Person.class).produces("text/plain").to("seda:personString").get("/binding/json/producer").to("direct:personJson").post("/pojo/binding/xml").bindingMode(RestBindingMode.xml).type(Person.class).produces("text/plain").to("seda:personString").get("/binding/xml/producer").to("direct:personXml").post("/log").to("direct:hello").verb("head", "/custom/verb").to("seda:contentTypeText").post("/multipart/upload").to("direct:processAttachments");
        this.from("seda:echoMethodPath").setBody().simple("${header.CamelHttpMethod}: ${header.CamelHttpPath}");
        this.from("seda:echoBodyPath").setBody().simple("${body}: ${header.CamelHttpPath}");
        this.from("direct:greetWithBody").setBody((Expression)this.simple("${header.messageStart} ${body} ${header.messageEnd}"));
        this.from("direct:greet").setBody((Expression)this.simple("${header.messageStart} ${header.messageEnd}"));
        this.from("direct:hello").log("Hello ${body}");
        ((RouteDefinition)this.from("seda:personString").setHeader("Content-Type", (Expression)this.constant("text/plain"))).setBody().simple("Name: ${body.firstName} ${body.lastName}, Age: ${body.age}");
        this.from("direct:personJson").setBody().constant((Object)PERSON_JSON);
        this.from("direct:personXml").setBody().constant((Object)PERSON_XML);
        this.from("seda:contentTypeText").setHeader("Content-Type").constant((Object)"text/plain");
        this.from("direct:processAttachments").process(exchange -> {
            AttachmentMessage attachmentMessage = (AttachmentMessage)exchange.getMessage(AttachmentMessage.class);
            Map attachments = attachmentMessage.getAttachments();
            if (attachments != null) {
                int size = attachments.size();
                exchange.getMessage().setBody((Object)String.valueOf(size));
            } else {
                exchange.getMessage().setBody((Object)"0");
            }
        });
    }
}

