/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.it;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.quarkus.component.rest.it.Person;

public class RestRoutes
extends RouteBuilder {
    private static final String PERSON_JSON = "{\"firstName\": \"John\", \"lastName\": \"Doe\", \"age\": 64}";
    private static final String PERSON_XML = "<person firstName=\"John\" lastName=\"Doe\" age=\"64\"/>";

    public void configure() {
        this.restConfiguration().enableCORS(true).corsAllowCredentials(true).corsHeaderProperty("Access-Control-Allow-Methods", "GET, POST").endpointProperty("fileNameExtWhitelist", ".txt");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.rest("/rest").delete().produces("text/plain").route().setBody((Expression)this.constant("DELETE: /rest"))).endRest().get().produces("text/plain").route().setBody((Expression)this.constant("GET: /rest"))).endRest().head().route().setHeader("Content-Type").constant((Object)"text/plain")).endRest().patch().consumes("text/plain").produces("text/plain").route().setBody((Expression)this.simple("${body}: /rest"))).endRest().post().consumes("text/plain").produces("text/plain").route().setBody((Expression)this.simple("${body}: /rest"))).endRest().put().consumes("text/plain").produces("text/plain").route().setBody((Expression)this.simple("${body}: /rest"))).endRest().post("/validation").clientRequestValidation(true).param().name("messageStart").type(RestParamType.query).required(Boolean.valueOf(true)).endParam().param().name("messageMiddle").type(RestParamType.body).required(Boolean.valueOf(true)).endParam().param().name("messageEnd").type(RestParamType.header).required(Boolean.valueOf(true)).endParam().param().name("unused").type(RestParamType.formData).required(Boolean.valueOf(false)).endParam().route().setBody((Expression)this.simple("${header.messageStart} ${body} ${header.messageEnd}"))).endRest().get("/template/{messageStart}/{messageEnd}").route().setBody((Expression)this.simple("${header.messageStart} ${header.messageEnd}"))).endRest().post("/pojo/binding/json").bindingMode(RestBindingMode.json).type(Person.class).produces("text/plain").route().setBody((Expression)this.simple("Name: ${body.firstName} ${body.lastName}, Age: ${body.age}"))).setHeader("Content-Type", (Expression)this.constant("text/plain"))).endRest().get("/binding/json/producer").route().setBody((Expression)this.constant(PERSON_JSON))).endRest().post("/pojo/binding/xml").bindingMode(RestBindingMode.xml).type(Person.class).produces("text/plain").route().setBody((Expression)this.simple("Name: ${body.firstName} ${body.lastName}, Age: ${body.age}"))).setHeader("Content-Type", (Expression)this.constant("text/plain"))).endRest().get("/binding/xml/producer").route().setBody((Expression)this.constant(PERSON_XML))).endRest().post("/log").route().log("Hello ${body}")).endRest().verb("head", "/custom/verb").route().setHeader("Content-Type", (Expression)this.constant("text/plain"))).endRest().post("/multipart/upload").route().process(exchange -> {
            AttachmentMessage attachmentMessage = (AttachmentMessage)exchange.getMessage(AttachmentMessage.class);
            Map attachments = attachmentMessage.getAttachments();
            if (attachments != null) {
                int size = attachments.size();
                exchange.getMessage().setBody((Object)String.valueOf(size));
            } else {
                exchange.getMessage().setBody((Object)"0");
            }
        })).endRest();
    }
}

