/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.quarkus.component.rest.it.Person;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class RestTest {
    private static final Person person = new Person("John", "Doe", 64);

    RestTest() {
    }

    @Test
    public void inspectConfiguration() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/rest/inspect/configuration", new Object[0])).then()).statusCode(200)).body("component", Matchers.is((Object)"platform-http"), new Object[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"DELETE", "GET", "HEAD", "PATCH", "POST", "PUT"})
    public void rest(String method) {
        String body = method.matches("PATCH|POST|PUT") ? method : "";
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(body).request(method, "/rest", new Object[0])).then()).header("Access-Control-Allow-Headers", Matchers.matchesPattern((String)".*Access-Control.*"))).header("Access-Control-Allow-Methods", Matchers.matchesPattern((String)"GET, POST"))).header("Access-Control-Allow-Credentials", CoreMatchers.equalTo((Object)"true"));
        if (method.equals("HEAD")) {
            response.statusCode(204);
            response.header("Content-Type", ContentType.TEXT.toString());
        } else {
            response.statusCode(200);
            response.body(Matchers.is((Object)(method + ": /rest")), new Matcher[0]);
        }
    }

    @Test
    public void pathTemplate() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/rest/template/Hello/World", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello World"), new Matcher[0]);
    }

    @Test
    public void requestValidation() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Camel Quarkus").header("messageEnd", (Object)"REST", new Object[0]).post("/rest/validation", new Object[0])).then()).statusCode(400)).body(CoreMatchers.equalTo((Object)"Some of the required query parameters are missing."), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("messageStart", new Object[]{"Hello"}).header("messageEnd", (Object)"REST", new Object[0]).post("/rest/validation", new Object[0])).then()).statusCode(400)).body(CoreMatchers.equalTo((Object)"The request body is missing."), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("messageStart", new Object[]{"Hello"}).body("Camel Quarkus").post("/rest/validation", new Object[0])).then()).statusCode(400)).body(CoreMatchers.equalTo((Object)"Some of the required HTTP headers are missing."), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("messageStart", new Object[]{"Hello"}).body("Camel Quarkus").header("messageEnd", (Object)"REST", new Object[0]).post("/rest/validation", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello Camel Quarkus REST"), new Matcher[0]);
    }

    @Test
    public void jsonBinding() {
        String result = String.format("Name: %s %s, Age: %d", person.getFirstName(), person.getLastName(), person.getAge());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)person).post("/rest/pojo/binding/json", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)result), new Matcher[0]);
    }

    @Test
    public void jsonBindingProducer() {
        Person respondPerson = (Person)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).get("/rest/producer/binding/mode/json", new Object[0])).then()).statusCode(200)).extract().body().as(Person.class);
        Assertions.assertEquals((Object)respondPerson, (Object)person);
    }

    @Test
    public void xmlBinding() {
        String result = String.format("Name: %s %s, Age: %d", person.getFirstName(), person.getLastName(), person.getAge());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body((Object)person).post("/rest/pojo/binding/xml", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)result), new Matcher[0]);
    }

    @Test
    public void xmlBindingProducer() {
        Person respondPerson = (Person)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).get("/rest/producer/binding/mode/xml", new Object[0])).then()).statusCode(200)).extract().body().as(Person.class);
        Assertions.assertEquals((Object)respondPerson, (Object)person);
    }

    @Test
    public void testRestProducer() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).get("/rest/invoke/route", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello Invoked"), new Matcher[0]);
    }

    @Test
    public void lightweight() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/rest/inspect/camel-context/lightweight", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @Test
    public void restLog() {
        String message = "Camel Quarkus Platform HTTP";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).when().post("/rest/log", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)message), new Matcher[0]);
    }

    @Test
    public void customVerb() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().head("/rest/custom/verb", new Object[0])).then()).statusCode(204)).header("Content-Type", Matchers.is((Object)ContentType.TEXT.toString()));
    }

    @Test
    public void multiPartUpload() throws IOException {
        Path txtFile = Files.createTempFile("multipartUpload", ".txt", new FileAttribute[0]);
        Path csvFile = Files.createTempFile("multipartUpload", ".csv", new FileAttribute[0]);
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart(txtFile.toFile()).post("/rest/multipart/upload", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart(csvFile.toFile()).post("/rest/multipart/upload", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"0"), new Matcher[0]);
        }
        finally {
            Files.deleteIfExists(txtFile);
            Files.deleteIfExists(csvFile);
        }
    }
}

