/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.it;

import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;

@Path(value="/rest")
@ApplicationScoped
public class RestResource {
    @Inject
    CamelContext camelContext;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/inspect/configuration")
    @GET
    @Produces(value={"application/json"})
    public JsonObject inspectConfiguration() {
        return Json.createObjectBuilder().add("component", this.camelContext.getRestConfiguration().getComponent()).build();
    }

    @Path(value="/inspect/camel-context/lightweight")
    @GET
    @Produces(value={"text/plain"})
    public boolean lightweight() {
        return ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).isLightweight();
    }

    @Path(value="/invoke/route")
    @GET
    @Produces(value={"text/plain"})
    public String restProducer(@QueryParam(value="port") int port) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("messageStart", "Hello");
        headers.put("messageEnd", "Invoked");
        return (String)this.producerTemplate.requestBodyAndHeaders("rest:get:/rest/template/{messageStart}/{messageEnd}?host=localhost:" + port, null, headers, String.class);
    }
}

