/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.rest.it.Person;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class RestTest {
    RestTest() {
    }

    @Test
    public void inspectConfiguration() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/rest/inspect/configuration", new Object[0])).then()).statusCode(200)).body("component", Matchers.is((Object)"platform-http"), new Object[0]);
    }

    @Test
    public void rest() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/rest/get", (Object[])new Object[0]).then()).header("Access-Control-Allow-Headers", Matchers.matchesPattern((String)".*Access-Control.*"))).header("Access-Control-Allow-Methods", Matchers.matchesPattern((String)"GET, POST"))).header("Access-Control-Allow-Credentials", CoreMatchers.equalTo((Object)"true"))).body(CoreMatchers.equalTo((Object)"GET: /rest/get"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).post("/rest/post", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"POST: /rest/post"), new Matcher[0]);
    }

    @Test
    public void pathTemplate() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/rest/template/Hello/World", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello World"), new Matcher[0]);
    }

    @Test
    public void requestValidation() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Camel Quarkus").header("messageEnd", (Object)"REST", new Object[0]).post("/rest/validation", new Object[0])).then()).statusCode(400)).body(CoreMatchers.equalTo((Object)"Some of the required query parameters are missing."), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("messageStart", new Object[]{"Hello"}).header("messageEnd", (Object)"REST", new Object[0]).post("/rest/validation", new Object[0])).then()).statusCode(400)).body(CoreMatchers.equalTo((Object)"The request body is missing."), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("messageStart", new Object[]{"Hello"}).body("Camel Quarkus").post("/rest/validation", new Object[0])).then()).statusCode(400)).body(CoreMatchers.equalTo((Object)"Some of the required HTTP headers are missing."), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("messageStart", new Object[]{"Hello"}).body("Camel Quarkus").header("messageEnd", (Object)"REST", new Object[0]).post("/rest/validation", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello Camel Quarkus REST"), new Matcher[0]);
    }

    @Test
    public void jsonBinding() {
        Person person = new Person();
        person.setFirstName("John");
        person.setLastName("Doe");
        person.setAge(64);
        String result = String.format("Name: %s %s, Age: %d", person.getFirstName(), person.getLastName(), person.getAge());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)person).post("/rest/pojo/binding/json", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)result), new Matcher[0]);
    }

    @Test
    public void xmlBinding() {
        Person person = new Person();
        person.setFirstName("John");
        person.setLastName("Doe");
        person.setAge(64);
        String result = String.format("Name: %s %s, Age: %d", person.getFirstName(), person.getLastName(), person.getAge());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body((Object)person).post("/rest/pojo/binding/xml", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)result), new Matcher[0]);
    }

    @Test
    public void testRestProducer() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).get("/rest/invoke/route", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello Invoked"), new Matcher[0]);
    }

    @Test
    public void lightweight() throws Throwable {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/rest/inspect/camel-context/lightweight", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @Test
    public void restLog() throws Throwable {
        String message = "Camel Quarkus Platform HTTP";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).when().post("/rest/log", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)message), new Matcher[0]);
    }
}

