/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.openapi.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.quarkus.component.rest.openapi.it.RestOpenApiBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
class RestOpenapiTest {
    private static final String OUTPUT_DIRECTORY = "target";
    private static final String OPENAPI_FILE = "openapi.json";

    RestOpenapiTest() {
    }

    @BeforeAll
    public static void createOpenApiJsonFile() throws Exception {
        RestOpenApiBean bean = new RestOpenApiBean();
        String openApiContents = bean.getOpenApiJson();
        Files.createDirectories(Paths.get(OUTPUT_DIRECTORY, new String[0]), new FileAttribute[0]);
        Files.writeString(Paths.get(OUTPUT_DIRECTORY, OPENAPI_FILE), (CharSequence)openApiContents, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    @AfterAll
    public static void deleteOpenApiJsonFile() {
        File openApiFile = new File(OUTPUT_DIRECTORY, OPENAPI_FILE);
        openApiFile.delete();
    }

    @Test
    public void testInvokeApiEndpoint() {
        this.invokeApiEndpoint("/rest-openapi/fruits/list/json");
    }

    @Test
    public void testInvokeYamlApiEndpoint() {
        this.invokeApiEndpoint("/rest-openapi/fruits/list/yaml");
    }

    @Test
    public void testInvokeFileApiEndpoint() {
        this.invokeApiEndpoint("/rest-openapi/fruits/list/file");
    }

    @Test
    public void testInvokeBeanApiEndpoint() {
        this.invokeApiEndpoint("/rest-openapi/fruits/list/bean");
    }

    @Test
    public void testInvokeClasspathApiEndpoint() {
        this.invokeApiEndpoint("/rest-openapi/fruits/list/classpath");
    }

    @Test
    public void testInvokeApiEndpointWithRequestValidationEnabled() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).contentType(ContentType.JSON).post("/rest-openapi/fruits/add", new Object[0])).then()).statusCode(500)).body(Matchers.is((Object)"A request body is required but none found."), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).contentType(ContentType.JSON).body("{\"name\": \"Orange\"}").post("/rest-openapi/fruits/add", new Object[0])).then()).statusCode(500)).body(Matchers.is((Object)"Object has missing required properties ([\"description\"])"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).contentType(ContentType.JSON).body("{\"name\": \"Orange\",\"description\":\"Tasty fruit\"}").post("/rest-openapi/fruits/add", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Fruit created"), new Matcher[0]);
    }

    private void invokeApiEndpoint(String path) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).get(path, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("description", Matchers.containsInAnyOrder((Object[])new String[]{"Winter fruit", "Tropical fruit"}), new Object[]{"name", Matchers.containsInAnyOrder((Object[])new String[]{"Apple", "Pineapple"})});
    }
}

