/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.openapi.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.rest.openapi.RestOpenApiValidationException;

@Path(value="/rest-openapi")
@ApplicationScoped
public class RestOpenapiResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/fruits/list/json")
    @Produces(value={"application/json"})
    @GET
    public Response invokeApiOperation(@QueryParam(value="port") int port) {
        return this.invokeApiOperation("start-web-json", port);
    }

    @Path(value="/fruits/list/yaml")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperationYaml(@QueryParam(value="port") int port) {
        return this.invokeApiOperation("start-web-yaml", port);
    }

    @Path(value="/fruits/list/file")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperationFile(@QueryParam(value="port") int port) {
        return this.invokeApiOperation("start-file", port);
    }

    @Path(value="/fruits/list/bean")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperationBean(@QueryParam(value="port") int port) {
        return this.invokeApiOperation("start-bean", port);
    }

    @Path(value="/fruits/list/classpath")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperationClasspath(@QueryParam(value="port") int port) {
        return this.invokeApiOperation("start-classpath", port);
    }

    @Path(value="/fruits/add")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @POST
    public Response invokeAddFruitOperation(final @QueryParam(value="port") int port, final String fruitJson) {
        Exchange result = this.producerTemplate.request("direct:validate", new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message message = exchange.getMessage();
                message.setHeader("Content-Type", (Object)"application/json");
                message.setHeader("test-port", (Object)port);
                message.setBody((Object)fruitJson);
            }
        });
        Exception exception = result.getException();
        if (exception != null) {
            String errorMessage = "";
            if (exception instanceof RestOpenApiValidationException) {
                RestOpenApiValidationException validationException = (RestOpenApiValidationException)exception;
                errorMessage = validationException.getValidationErrors().stream().collect(Collectors.joining(","));
            }
            return Response.serverError().entity((Object)errorMessage).build();
        }
        return Response.ok().entity(result.getMessage().getBody(String.class)).build();
    }

    private Response invokeApiOperation(String endpointName, int port) {
        String response = (String)this.producerTemplate.requestBodyAndHeader("direct:" + endpointName, null, "test-port", (Object)port, String.class);
        return Response.ok().entity((Object)response).build();
    }
}

