/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.openapi.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;

@Path(value="/rest-openapi")
@ApplicationScoped
public class RestOpenapiResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/fruits/list/json")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperation(@QueryParam(value="port") int port) {
        return this.invokeListFruitsOperation("start-web-json", port);
    }

    @Path(value="/fruits/list/yaml")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperationYaml(@QueryParam(value="port") int port) {
        return this.invokeListFruitsOperation("start-web-yaml", port);
    }

    @Path(value="/fruits/list/file")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperationFile(@QueryParam(value="port") int port) {
        return this.invokeListFruitsOperation("start-file", port);
    }

    @Path(value="/fruits/list/bean")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperationBean(@QueryParam(value="port") int port) {
        return this.invokeListFruitsOperation("start-bean", port);
    }

    @Path(value="/fruits/list/classpath")
    @Produces(value={"application/json"})
    @GET
    public Response invokeListFruitsOperationClasspath(@QueryParam(value="port") int port) {
        return this.invokeListFruitsOperation("start-classpath", port);
    }

    private Response invokeListFruitsOperation(String endpointName, int port) {
        String response = (String)this.producerTemplate.requestBodyAndHeader("direct:" + endpointName, null, "test-port", (Object)port, String.class);
        return Response.ok().entity((Object)response).build();
    }
}

