/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ref.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.support.ExpressionAdapter;

@Path(value="/ref")
@ApplicationScoped
public class RefResource {
    @Inject
    CamelContext camelContext;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    public void produceMessage(@QueryParam(value="uri") String uri, String message) {
        this.producerTemplate.sendBody(uri, (Object)message);
    }

    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String consumeMessage(@QueryParam(value="uri") String uri) {
        return (String)this.consumerTemplate.receiveBody(uri, 5000L, String.class);
    }

    @Singleton
    @Named(value="direct-start-a")
    @jakarta.enterprise.inject.Produces
    public Endpoint directStartA() {
        return this.camelContext.getEndpoint("direct:startA");
    }

    @Singleton
    @Named(value="direct-start-b")
    @jakarta.enterprise.inject.Produces
    public Endpoint directStartB() {
        return this.camelContext.getEndpoint("direct:startB");
    }

    @Singleton
    @Named(value="seda-end-a")
    @jakarta.enterprise.inject.Produces
    public Endpoint sedaEndA() {
        return this.camelContext.getEndpoint("seda:endA");
    }

    @Singleton
    @Named(value="seda-end-b")
    @jakarta.enterprise.inject.Produces
    public Endpoint sedaEndB() {
        return this.camelContext.getEndpoint("seda:endB");
    }

    @Singleton
    @Named(value="my-expression")
    @jakarta.enterprise.inject.Produces
    public Expression myExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return ((String)exchange.getMessage().getBody(String.class)).toUpperCase();
            }
        };
    }

    @Singleton
    @Named(value="my-route")
    @jakarta.enterprise.inject.Produces
    public RoutesBuilder myRoute() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)this.from("direct-start-a").transform().ref("my-expression")).to("seda-end-a");
                ((ProcessorDefinition)this.from("ref:direct-start-b").transform().ref("my-expression")).to("ref:seda-end-b");
            }
        };
    }
}

