/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ref.it;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.ExpressionAdapter;

@Path(value="/ref")
@ApplicationScoped
public class RefResource {
    @Inject
    CamelContext camelContext;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    @javax.ws.rs.Produces(value={"text/plain"})
    public String post(String message) {
        return (String)this.producerTemplate.requestBody("my-endpoint", (Object)message, String.class);
    }

    @Singleton
    @Named(value="my-endpoint")
    @Produces
    public Endpoint myEndpoint() {
        return this.camelContext.getEndpoint("direct:start");
    }

    @Singleton
    @Named(value="my-expression")
    @Produces
    public Expression myExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return ((String)exchange.getMessage().getBody(String.class)).toUpperCase();
            }
        };
    }

    @Singleton
    @Named(value="my-route")
    @Produces
    public RoutesBuilder myRoute() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("my-endpoint").transform().ref("my-expression");
            }
        };
    }
}

