/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.redis.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/redis")
@ApplicationScoped
public class RedisResource {
    private static final Logger LOG = Logger.getLogger(RedisResource.class);
    private ConcurrentLinkedQueue<String> aggregates = new ConcurrentLinkedQueue();
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/aggregate/{message}/{correlationKey}")
    @POST
    public void aggregate(@PathParam(value="message") String message, @PathParam(value="correlationKey") int correlationKey) {
        LOG.debugf("Calling aggregate(%s, %d)", (Object)message, (Object)correlationKey);
        this.producerTemplate.sendBodyAndHeader("direct:start", (Object)message, "myId", (Object)correlationKey);
    }

    @Path(value="/get-aggregates")
    @GET
    @Produces(value={"application/json"})
    public ConcurrentLinkedQueue<String> getAggregates() {
        LOG.debug((Object)"Calling getAggregates()");
        return this.aggregates;
    }

    void storeMessage(String message) {
        this.aggregates.add(message);
    }
}

