/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.redis.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.redis.processor.aggregate.RedisAggregationRepository;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.redis.it.MyAggregationStrategy;
import org.apache.camel.quarkus.component.redis.it.RedisResource;
import org.apache.camel.spi.AggregationRepository;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class RedisRoute
extends RouteBuilder {
    @ConfigProperty(name="camel.redis.test.server.authority")
    String redisUrl;
    @Inject
    RedisResource redisResource;

    public void configure() {
        ((AggregateDefinition)((RouteDefinition)this.from("direct:start").log("Aggregating \"${body}\" with correlation key \"${header.myId}\"")).aggregate((Expression)this.header("myId"), (AggregationStrategy)new MyAggregationStrategy()).aggregationRepository((AggregationRepository)new RedisAggregationRepository("aggregation", this.redisUrl)).completionSize(3).log("Completed the aggregate \"${body}\"")).bean((Object)this.redisResource, "storeMessage");
    }
}

