/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.redis.it;

import java.util.concurrent.ConcurrentLinkedQueue;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/redis")
@ApplicationScoped
public class RedisResource {
    private static final Logger LOG = Logger.getLogger(RedisResource.class);
    private ConcurrentLinkedQueue<String> aggregates = new ConcurrentLinkedQueue();
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/aggregate/{message}/{correlationKey}")
    @POST
    public void aggregate(@PathParam(value="message") String message, @PathParam(value="correlationKey") int correlationKey) {
        LOG.debugf("Calling aggregate(%s, %d)", (Object)message, (Object)correlationKey);
        this.producerTemplate.sendBodyAndHeader("direct:start", (Object)message, "myId", (Object)correlationKey);
    }

    @Path(value="/get-aggregates")
    @GET
    @Produces(value={"application/json"})
    public ConcurrentLinkedQueue<String> getAggregates() {
        LOG.debug((Object)"Calling getAggregates()");
        return this.aggregates;
    }

    void storeMessage(String message) {
        this.aggregates.add(message);
    }
}

