/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.redis.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class RedisTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTestResource.class);
    private static final int REDIS_PORT = 6379;
    private static final String REDIS_IMAGE = "redis:6.0.9";
    private GenericContainer container;

    public Map<String, String> start() {
        LOG.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(REDIS_IMAGE).withExposedPorts(new Integer[]{6379}).waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            String authority = this.container.getHost() + ":" + this.container.getMappedPort(6379).toString();
            return CollectionHelper.mapOf((Object)"camel.redis.test.server.authority", (Object)authority, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

