/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.redis.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.redis.it.RedisTestResource;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=RedisTestResource.class)
class RedisTest {
    RedisTest() {
    }

    @Test
    public void aggregateUsingRedisPersistentRepositoryShouldSucceed() {
        ((ValidatableResponse)RestAssured.post((String)"/redis/aggregate/{message}/{correlationKey}", (Object[])new Object[]{"A", 1}).then()).statusCode(204);
        ((ValidatableResponse)RestAssured.post((String)"/redis/aggregate/{message}/{correlationKey}", (Object[])new Object[]{"B", 1}).then()).statusCode(204);
        ((ValidatableResponse)RestAssured.post((String)"/redis/aggregate/{message}/{correlationKey}", (Object[])new Object[]{"F", 2}).then()).statusCode(204);
        ((ValidatableResponse)RestAssured.post((String)"/redis/aggregate/{message}/{correlationKey}", (Object[])new Object[]{"C", 1}).then()).statusCode(204);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().contentType(ContentType.JSON).get("/redis/get-aggregates", new Object[0])).path("size()", new String[0]).equals(1));
        String[] results = (String[])((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/redis/get-aggregates", new Object[0])).then()).extract().as(String[].class);
        Assertions.assertEquals((int)1, (int)results.length);
        Assertions.assertEquals((Object)"ABC", (Object)results[0]);
    }
}

