/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rabbitmq.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class RabbitmqTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitmqTestResource.class);
    private static final String RABBITMQ_IMAGE = "rabbitmq:3.8.7-alpine";
    private static final int RABBITMQ_PORT = 5672;
    private static final String RABBITMQ_USERNAME = "guest";
    private static final String RABBITMQ_PASSWORD = "guest";
    private GenericContainer<?> container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(RABBITMQ_IMAGE).withExposedPorts(new Integer[]{5672}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Server startup complete.*", (int)1));
            this.container.start();
            return CollectionHelper.mapOf((Object)"camel.component.rabbitmq.port-number", (Object)this.container.getMappedPort(5672).toString(), (Object[])new Object[]{"camel.component.rabbitmq.hostname", this.container.getHost(), "camel.component.rabbitmq.username", "guest", "camel.component.rabbitmq.password", "guest", "camel.component.rabbitmq.declare", "true"});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

