/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rabbitmq.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;

@Path(value="/rabbitmq")
@ApplicationScoped
public class RabbitmqResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/{exchangeName}/{queueName}")
    @GET
    @Produces(value={"text/plain"})
    public String consumeRabbitmqMessage(@PathParam(value="exchangeName") String exchangeName, @PathParam(value="queueName") String queueName) {
        return (String)this.consumerTemplate.receiveBody("rabbitmq:" + exchangeName + "?queue=" + queueName, 5000L, String.class);
    }

    @Path(value="/{exchangeName}/{queueName}")
    @POST
    @Consumes(value={"text/plain"})
    public Response produceRabbitmqMessage(@PathParam(value="exchangeName") String exchangeName, @PathParam(value="queueName") String queueName, String message) throws Exception {
        this.producerTemplate.sendBody("rabbitmq:" + exchangeName + "?queue=" + queueName, (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

