/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.quartz.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class QuartzTest {
    QuartzTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"cron", "quartz"})
    public void testSchedulerComponent(String component) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromEndpoint", new Object[]{component}).get("/quartz/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello Camel Quarkus " + component)), new Matcher[0]);
    }

    @Test
    @Disabled(value="Features unavailable on Camel 3.14.2")
    public void testProperties() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromEndpoint", new Object[]{"quartz-properties"}).queryParam("componentName", new Object[]{"quartzFromProperties"}).get("/quartz/getNameAndResult", new Object[0])).then()).statusCode(200)).body("name", Matchers.is((Object)"MyScheduler-"), new Object[]{"result", Matchers.is((Object)"Hello Camel Quarkus Quartz Properties")});
    }

    @Test
    public void testCronTrigger() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromEndpoint", new Object[]{"quartz-cron-trigger"}).get("/quartz/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Quartz From Cron Trigger"), new Matcher[0]);
    }

    @Test
    public void testHeaders() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromEndpoint", new Object[]{"quartz"}).get("/quartz/getHeaders", new Object[0])).then()).statusCode(200)).body("triggerName", Matchers.is((Object)"1 * * * * "), new Object[0]);
    }

    @Test
    public void testMisfire() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromEndpoint", new Object[]{"quartz-cron-misfire"}).get("/quartz/getMisfire", new Object[0])).then()).statusCode(200)).body("timezone", Matchers.is((Object)"Europe/Stockholm"), new Object[]{"misfire", Matchers.is((Object)"2")});
    }

    @Test
    @Disabled(value="Features unavailable on Camel 3.14.2")
    public void testClustered() throws InterruptedException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromEndpoint", new Object[]{"quartz-nodeA"}).get("/quartz/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Quartz NodeA"), new Matcher[0]);
    }

    @Test
    @Disabled(value="Features unavailable on Camel 3.14.2")
    public void testClusteredWithNamedDS() throws InterruptedException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromEndpoint", new Object[]{"quartz-nodeB"}).get("/quartz/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Quartz NodeB"), new Matcher[0]);
    }

    @Test
    @Disabled(value="Features unavailable on Camel 3.14.2")
    public void testClusteredWithoutDS() throws InterruptedException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromEndpoint", new Object[]{"quartz-nodeC"}).get("/quartz/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Quartz NodeC"), new Matcher[0]);
    }
}

