/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pubnub.it;

import com.google.gson.JsonElement;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.enums.PNReconnectionPolicy;
import com.pubnub.api.models.consumer.presence.PNGetStateResult;
import com.pubnub.api.models.consumer.presence.PNHereNowResult;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/pubnub")
public class PubnubResource {
    @ConfigProperty(name="pubnub.publish.key")
    String publishKey;
    @ConfigProperty(name="pubnub.subscribe.key")
    String subscribeKey;
    @ConfigProperty(name="pubnub.secret.key")
    String secretKey;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/publish/{channel}")
    @POST
    @javax.ws.rs.Produces(value={"text/plain"})
    public Response publish(@PathParam(value="channel") String channel, String message) throws Exception {
        if (channel.equals("test")) {
            this.context.getRouteController().startRoute("subscriber-route");
        }
        this.producerTemplate.sendBodyAndHeader("direct:publish", (Object)message, "CamelPubNubChannel", (Object)channel);
        return Response.created((URI)new URI("https://camel.apache.org")).build();
    }

    @Path(value="/subscribe")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public String subscribe() throws Exception {
        try {
            PNMessageResult result = (PNMessageResult)this.consumerTemplate.receiveBody("seda:messages", 10000L, PNMessageResult.class);
            String string = result.getMessage().getAsString();
            return string;
        }
        finally {
            this.context.getRouteController().stopRoute("subscriber-route");
        }
    }

    @Path(value="/fire")
    @POST
    @javax.ws.rs.Produces(value={"text/plain"})
    public String fire(String message) throws Exception {
        Exchange exchange = this.producerTemplate.request("pubnub:test-fire?pubNub=#pubNub&operation=fire", ex -> ex.getMessage().setBody((Object)message));
        return (String)exchange.getMessage().getHeader("CamelPubNubTimeToken", String.class);
    }

    @Path(value="/presence")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public String presence() throws Exception {
        try {
            this.context.getRouteController().startRoute("presence-route");
            PNPresenceEventResult result = (PNPresenceEventResult)this.consumerTemplate.receiveBody("seda:presence", 10000L, PNPresenceEventResult.class);
            String string = result.getChannel();
            return string;
        }
        finally {
            this.context.getRouteController().stopRoute("presence-route");
        }
    }

    @Path(value="/state")
    @POST
    @javax.ws.rs.Produces(value={"text/plain"})
    public void setState() throws Exception {
        HashMap<String, String> state = new HashMap<String, String>();
        state.put("test-state-key", "test-state-value");
        this.producerTemplate.requestBodyAndHeader("pubnub:test-state?pubNub=#pubNub", state, "CamelPubNubOperation", (Object)"SETSTATE");
    }

    @Path(value="/state")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public String getState() throws Exception {
        PNGetStateResult result = (PNGetStateResult)this.producerTemplate.requestBodyAndHeader("pubnub:test-state?pubNub=#pubNub", null, "CamelPubNubOperation", (Object)"GETSTATE", PNGetStateResult.class);
        return ((JsonElement)result.getStateByUUID().get("test-state")).getAsJsonObject().get("test-state-key").getAsString();
    }

    @Path(value="/history")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int history() throws Exception {
        List result = (List)this.producerTemplate.requestBodyAndHeader("pubnub:test-history?pubNub=#pubNub", null, "CamelPubNubOperation", (Object)"GETHISTORY", List.class);
        return result.size();
    }

    @Path(value="/herenow")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int herenow() throws Exception {
        PNHereNowResult result = (PNHereNowResult)this.producerTemplate.requestBodyAndHeader("pubnub:test-herenow?pubNub=#pubNub", null, "CamelPubNubOperation", (Object)"HERENOW", PNHereNowResult.class);
        return result.getTotalChannels();
    }

    @Produces
    @Singleton
    @Named
    public PubNub pubNub() {
        PNConfiguration configuration = new PNConfiguration();
        configuration.setPublishKey(this.publishKey);
        configuration.setSubscribeKey(this.subscribeKey);
        configuration.setSecretKey(this.secretKey);
        Optional url = ConfigProvider.getConfig().getOptionalValue("pubnub.url", String.class);
        if (url.isPresent()) {
            configuration.setOrigin((String)url.get());
            configuration.setSecure(false);
            configuration.setReconnectionPolicy(PNReconnectionPolicy.LINEAR);
        }
        return new PubNub(configuration);
    }
}

