/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.platform.http.it;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import org.apache.camel.Expression;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestBindingMode;

public class PlatformHttpRouteBuilder
extends RouteBuilder {
    public void configure() {
        this.restConfiguration().component("platform-http").bindingMode(RestBindingMode.off).dataFormatProperty("prettyPrint", "true").contextPath("my-context");
        ((RouteDefinition)((RouteDefinition)this.rest().get("/platform-http/rest-get").route().setBody((Expression)this.constant("GET: /rest-get"))).endRest().post("/platform-http/rest-post").consumes("text/plain").produces("text/plain").route().setBody((Expression)this.constant("POST: /rest-post"))).endRest();
        this.from("platform-http:/platform-http/hello?httpMethodRestrict=GET").setBody((Expression)this.simple("Hello ${header.name}"));
        this.from("platform-http:/platform-http/get-post?httpMethodRestrict=GET,POST").setBody((Expression)this.simple("Hello ${body}"));
        ((RouteDefinition)this.from("platform-http:/platform-http/multipart?httpMethodRestrict=POST").to("log:multipart")).process(e -> {
            AttachmentMessage am = (AttachmentMessage)e.getMessage(AttachmentMessage.class);
            DataHandler src = am.getAttachment("bytes.bin");
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                src.writeTo((OutputStream)out);
                e.getMessage().setBody((Object)out.toByteArray());
            }
        });
        ((RouteDefinition)this.from("platform-http:/platform-http/form-urlencoded?httpMethodRestrict=POST").to("log:form-urlencoded")).setBody(e -> ((Map)e.getMessage().getBody(Map.class)).entrySet().stream().map(en -> (String)en.getKey() + "=" + en.getValue().toString().toUpperCase(Locale.US)).collect(Collectors.joining("\n")));
        ((RouteDefinition)this.from("platform-http:/platform-http/header-filter-strategy?httpMethodRestrict=GET&headerFilterStrategy=#TestHeaderFilterStrategy").to("log:header-filter-strategy")).setBody((Expression)this.simple("k1=${header.k1}\nk2=${header.k2}"));
        ((RouteDefinition)this.from("platform-http:/platform-http/multi-value-params?httpMethodRestrict=GET").to("log:multi-value-params")).setBody((Expression)this.simple("k1=${header.k1}"));
        ((RouteDefinition)((RouteDefinition)this.from("platform-http:/platform-http/encoding?httpMethodRestrict=POST").to("log:encoding")).setBody(e -> (String)e.getMessage().getBody(String.class))).setHeader("Content-Type").constant((Object)"text/plain ; charset=UTF-8");
        ((RouteDefinition)this.from("platform-http:/platform-http/response-code-299?httpMethodRestrict=GET").to("log:response-code")).setHeader("CamelHttpResponseCode").constant((Object)299);
        this.from("platform-http:/platform-http/consumes?httpMethodRestrict=POST&consumes=text/plain").setBody((Expression)this.simple("Hello ${body}"));
        this.from("platform-http:/platform-http/produces?httpMethodRestrict=POST&produces=text/plain").setBody((Expression)this.simple("Hello ${body}"));
        this.from("platform-http:/platform-http/allmethods").setBody((Expression)this.simple("Hello ${header.CamelHttpMethod}"));
        this.from("platform-http:/platform-http/path/prefix?matchOnUriPrefix=true").setBody((Expression)this.simple("Hello ${header.CamelHttpPath}"));
        this.from("platform-http:/platform-http/log?httpMethodRestrict=POST&consumes=text/plain").log("Hello ${body}");
        this.from("platform-http:/platform-http/null-body").setBody((Expression)this.constant(null));
        this.from("platform-http:/platform-http/empty-string-body").setBody().constant((Object)"");
        this.from("platform-http:/platform-http/some-string").setBody().constant((Object)"No Content");
        ((RouteDefinition)this.from("platform-http:/platform-http/empty-string-200").setHeader("CamelHttpResponseCode", (Expression)this.constant(200))).setBody().constant((Object)"");
        ((RouteDefinition)this.rest().get("/platform-http/hello-by-name/{name}").produces("text/plain").route().setBody(e -> "Hello " + (String)e.getIn().getHeader("name", String.class))).endRest();
        this.from("platform-http:/platform-http/webhookpath").setBody((Expression)this.constant(WebhookConfiguration.computeDefaultPath((String)"webhook-delegate://test")));
        this.from("webhook:webhook-delegate://test").transform((Expression)this.body().prepend((Object)"Hello "));
    }
}

