/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.server.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpEngine;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@QuarkusTest
class PlatformHttpTest {
    PlatformHttpTest() {
    }

    @BeforeAll
    public static void beforeAll() {
        RestAssured.trustStore((String)"truststore.p12", (String)"s3cr3t");
    }

    @Test
    public void basic() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("name", new Object[]{"Kermit"}).get("/platform-http/hello", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello Kermit"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel").post("/platform-http/get-post", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello Camel"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/platform-http/get-post", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello "), new Matcher[0]);
    }

    @Test
    public void rest() throws Throwable {
        ((ValidatableResponse)RestAssured.get((String)"/my-context/platform-http/rest-get", (Object[])new Object[0]).then()).body(CoreMatchers.equalTo((Object)"GET: /my-context/platform-http/rest-get"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType("text/plain").post("/my-context/platform-http/rest-post", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"POST: /my-context/platform-http/rest-post"), new Matcher[0]);
    }

    @Test
    public void consumes() throws Throwable {
        ((ValidatableResponse)((Response)RestAssured.given().contentType("application/json").post("/my-context/platform-http/rest-post", new Object[0])).then()).statusCode(415);
        ((ValidatableResponse)((Response)RestAssured.given().contentType("text/plain").post("/my-context/platform-http/rest-post", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType("application/json").post("/platform-http/consumes", new Object[0])).then()).statusCode(415);
        ((ValidatableResponse)((Response)RestAssured.given().contentType("text/plain").post("/platform-http/consumes", new Object[0])).then()).statusCode(200);
    }

    @Test
    public void produces() throws Throwable {
        ((ValidatableResponse)((Response)RestAssured.given().accept("application/json").contentType("text/plain").post("/my-context/platform-http/rest-post", new Object[0])).then()).statusCode(406);
        ((ValidatableResponse)((Response)RestAssured.given().accept("text/plain").contentType("text/plain").post("/my-context/platform-http/rest-post", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().accept("application/json").contentType("text/plain").post("/platform-http/produces", new Object[0])).then()).statusCode(406);
        ((ValidatableResponse)((Response)RestAssured.given().accept("text/plain").contentType("text/plain").post("/platform-http/produces", new Object[0])).then()).statusCode(200);
    }

    @Test
    public void invalidMethod() {
        ((ValidatableResponse)RestAssured.post((String)"/platform-http/hello", (Object[])new Object[0]).then()).statusCode(405);
        ((ValidatableResponse)RestAssured.post((String)"/my-context/platform-http/rest-get", (Object[])new Object[0]).then()).statusCode(405);
        ((ValidatableResponse)RestAssured.get((String)"/my-context/platform-http/rest-post", (Object[])new Object[0]).then()).statusCode(405);
    }

    @Test
    public void multipart() {
        byte[] bytes = new byte[]{12, 0, 15, 14, 11, 10, 11, 14};
        byte[] returnedBytes = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("multipart/form-data").multiPart("file", "bytes.bin", bytes).formParam("description", new Object[]{"cofe babe"}).post("/platform-http/multipart", new Object[0])).then()).statusCode(200)).extract().body().asByteArray();
        Assertions.assertArrayEquals((byte[])bytes, (byte[])returnedBytes);
    }

    @Test
    public void formUrlEncoded() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("application/x-www-form-urlencoded").formParam("k1", new Object[]{"v1"}).formParam("k2", new Object[]{"v2"}).post("/platform-http/form-urlencoded", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"k1=V1\nk2=V2"), new Matcher[0]);
    }

    @Test
    public void customHeaderFilterStrategy() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("k1", new Object[]{"v1"}).queryParam("k2", new Object[]{"v2"}).get("/platform-http/header-filter-strategy", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"k1=\nk2=v2"), new Matcher[0]);
    }

    @Test
    public void multiValueParams() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("k1", new Object[]{"v1"}).queryParam("k1", new Object[]{"v2"}).get("/platform-http/multi-value-params", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"k1=[v1, v2]"), new Matcher[0]);
    }

    @Test
    public void encoding() throws UnsupportedEncodingException {
        String outgoingEncoding = "ISO-8859-2";
        String bodyText = "\u0164ava dvojhrb\u00e1";
        byte[] returnedBytes = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("text/plain; charset=ISO-8859-2").body("\u0164ava dvojhrb\u00e1".getBytes("ISO-8859-2")).post("/platform-http/encoding", new Object[0])).then()).statusCode(200)).extract().body().asByteArray();
        Assertions.assertArrayEquals((byte[])"\u0164ava dvojhrb\u00e1".getBytes(StandardCharsets.UTF_8), (byte[])returnedBytes);
    }

    @Test
    public void responseCodeViaHeader() throws UnsupportedEncodingException {
        ((ValidatableResponse)((Response)RestAssured.given().get("/platform-http/response-code-299", new Object[0])).then()).statusCode(299);
    }

    @Test
    public void code204Null() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().get("/platform-http/null-body", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void code204EmptyString() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().get("/platform-http/empty-string-body", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void code204SomeString() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/platform-http/some-string", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"No Content"), new Matcher[0]);
    }

    @Test
    public void code200EmptyString() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/platform-http/empty-string-200", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)""), new Matcher[0]);
    }

    @Test
    public void pathParam() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/my-context/platform-http/hello-by-name/Kermit", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello Kermit"), new Matcher[0]);
    }

    @Test
    public void log() {
        String message = "Camel Quarkus Platform HTTP";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).when().post("/platform-http/log", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)message), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"httpMethods"})
    public void methods(Method method) {
        Object expected = "";
        if (!method.equals((Object)Method.HEAD)) {
            expected = "Hello " + method.name();
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().request(method, "/platform-http/allmethods", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)expected), new Matcher[0]);
    }

    @Test
    public void pathPrefix() {
        String basePath = "/platform-http/path";
        ((ValidatableResponse)((Response)RestAssured.given().get("/platform-http/path", new Object[0])).then()).statusCode(404);
        Object path = "/platform-http/path/prefix";
        for (int i = 0; i < 5; ++i) {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get((String)path, new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)("Hello " + (String)path)), new Matcher[0]);
            path = (String)path + "/" + i;
        }
    }

    @Test
    public void testWebhook() throws InterruptedException {
        String path = ((ValidatableResponse)((Response)RestAssured.given().get("/platform-http/webhookpath", new Object[0])).then()).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().urlEncodingEnabled(false).post("/my-context" + path, new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello Camel Quarkus Webhook"), new Matcher[0]);
    }

    @Test
    public void testPathSecuredWithBasicAuth() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/platform-http/secure/basic", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("camel", "s3cr3t").get("/platform-http/secure/basic", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("camel", "p4ssw0rd").get("/platform-http/secure/basic", new Object[0])).then()).statusCode(200)).header("Authorization", Matchers.notNullValue())).body(CoreMatchers.equalTo((Object)"camel:Admin"), new Matcher[0]);
    }

    @Test
    public void registrySetUp() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/registry/inspect", new Object[0])).then()).statusCode(200)).body("engine", CoreMatchers.is((Object)VertxPlatformHttpEngine.class.getName()), new Object[]{"component", CoreMatchers.is((Object)PlatformHttpComponent.class.getName())});
    }

    private static Method[] httpMethods() {
        return Method.values();
    }
}

