/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.platform.http.it;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.webhook.WebhookCapableEndpoint;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;

public class WebhookComponentProducer {
    @Produces
    @Named(value="webhook-delegate")
    TestWebhookComponent createWebhookComponent() {
        return new TestWebhookComponent();
    }

    static final class TestWebhookEndpoint
    extends DefaultEndpoint
    implements WebhookCapableEndpoint {
        private static final List<String> DEFAULT_METHOD = Collections.unmodifiableList(Collections.singletonList("POST"));
        private Function<Processor, Processor> webhookHandler;
        private Runnable register;
        private Runnable unregister;
        private Supplier<List<String>> methods;
        private Supplier<Producer> producer;
        private Function<Processor, Consumer> consumer;
        private WebhookConfiguration webhookConfiguration;

        public TestWebhookEndpoint(String uri, Component component) {
            super(uri, component);
        }

        public Processor createWebhookHandler(Processor next) {
            if (this.webhookHandler != null) {
                return this.webhookHandler.apply(next);
            }
            return next;
        }

        public void registerWebhook() {
            if (this.register != null) {
                this.register.run();
            }
        }

        public void unregisterWebhook() {
            if (this.unregister != null) {
                this.unregister.run();
            }
        }

        public void setWebhookConfiguration(WebhookConfiguration webhookConfiguration) {
            this.webhookConfiguration = webhookConfiguration;
        }

        public List<String> getWebhookMethods() {
            return this.methods != null ? this.methods.get() : DEFAULT_METHOD;
        }

        public Producer createProducer() throws Exception {
            return this.producer != null ? this.producer.get() : null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return this.consumer != null ? this.consumer.apply(processor) : null;
        }

        public void setWebhookHandler(Function<Processor, Processor> webhookHandler) {
            this.webhookHandler = webhookHandler;
        }
    }

    static final class TestWebhookComponent
    extends DefaultComponent {
        TestWebhookComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            TestWebhookEndpoint endpoint = new TestWebhookEndpoint(uri, (Component)this);
            endpoint.setWebhookHandler(processor -> exchange -> {
                exchange.getMessage().setBody((Object)"Camel Quarkus Webhook");
                processor.process(exchange);
            });
            return endpoint;
        }
    }
}

