/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pgevent.it;

import jakarta.enterprise.context.ApplicationScoped;
import org.apache.camel.builder.RouteBuilder;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class PgeventRoutes
extends RouteBuilder {
    public static final String MOCK_ENDPOINT_CLASSIC_CONF = "mock:classic";
    public static final String MOCK_ENDPOINT_AGROALDATASOURCE = "mock:datasource";
    @ConfigProperty(name="database.host")
    String host;
    @ConfigProperty(name="database.port")
    Integer port;
    @ConfigProperty(name="database.name")
    String databaseName;
    @ConfigProperty(name="quarkus.datasource.pgDatasource.username")
    String user;
    @ConfigProperty(name="quarkus.datasource.pgDatasource.password")
    String password;

    public void configure() throws Exception {
        this.from("direct:pgevent-pub").to(String.format("pgevent://%s:%s/%s/testchannel?user=%s&pass=%s", this.host, this.port, this.databaseName, this.user, this.password));
        this.from(String.format("pgevent://%s:%s/%s/testchannel?user=%s&pass=%s", this.host, this.port, this.databaseName, this.user, this.password)).to(MOCK_ENDPOINT_CLASSIC_CONF);
        this.from("direct:pgevent-datasource").to("pgevent:///postgres/testchannel?datasource=#pgDatasource");
        this.from("pgevent:///postgres/testchannel?datasource=#pgDatasource").to(MOCK_ENDPOINT_AGROALDATASOURCE);
    }
}

