/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pgevent.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/pgevent")
@ApplicationScoped
public class PgeventResource {
    private static final Logger LOG = Logger.getLogger(PgeventResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @GET
    @Path(value="{event}")
    public Response publishEvent(@PathParam(value="event") String event) {
        LOG.infof("publish event %s", (Object)event);
        String response = (String)this.producerTemplate.requestBody("direct:pgevent-pub", (Object)event, String.class);
        LOG.infof("message received : %s", (Object)response);
        return Response.accepted((Object)response).build();
    }

    @GET
    @Path(value="datasource/{event}")
    public Response publishEventWithDatasource(@PathParam(value="event") String event) {
        LOG.infof("publish event %s", (Object)event);
        String response = (String)this.producerTemplate.requestBody("direct:pgevent-datasource", (Object)event, String.class);
        LOG.infof("message received : %s", (Object)response);
        return Response.accepted((Object)response).build();
    }
}

