/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pgevent.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.util.CollectionHelper;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class PgEventTestResource
implements QuarkusTestResourceLifecycleManager {
    protected static final String CONTAINER_NAME = "pg-event";
    protected static final String POSTGRES_USER = "postgres";
    protected static final String POSTGRES_PASSWORD = "mysecretpassword";
    protected static final String POSTGRES_DB = "postgres";
    private static final Logger LOGGER = LoggerFactory.getLogger(PgEventTestResource.class);
    private static final int POSTGRES_PORT = 5432;
    private static final String POSTGRES_IMAGE = (String)ConfigProvider.getConfig().getValue("postgres.container.image", String.class);
    private GenericContainer<?> container;

    public Map<String, String> start() {
        this.container = this.createContainer();
        this.container.start();
        return CollectionHelper.mapOf((Object)"database.port", (Object)this.container.getMappedPort(5432).toString(), (Object[])new Object[]{"database.host", this.container.getHost(), "quarkus.datasource.pgDatasource.jdbc.url", String.format("jdbc:pgsql://%s:%s/postgres", this.container.getHost(), this.container.getMappedPort(5432))});
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    private GenericContainer<?> createContainer() {
        return new GenericContainer(POSTGRES_IMAGE).withCommand("postgres -c wal_level=logical").withExposedPorts(new Integer[]{5432}).withNetworkAliases(new String[]{CONTAINER_NAME}).withEnv("POSTGRES_USER", "postgres").withEnv("POSTGRES_PASSWORD", POSTGRES_PASSWORD).withEnv("POSTGRES_DB", "postgres").withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forListeningPort());
    }
}

