/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pgevent.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/pgevent")
@ApplicationScoped
public class PgeventResource {
    private static final Logger LOG = Logger.getLogger(PgeventResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @GET
    @Path(value="{event}")
    public Response publishEvent(@PathParam(value="event") String event) {
        LOG.infof("publish event %s", (Object)event);
        String response = (String)this.producerTemplate.requestBody("direct:pgevent-pub", (Object)event, String.class);
        LOG.infof("message received : %s", (Object)response);
        return Response.accepted((Object)response).build();
    }

    @GET
    @Path(value="datasource/{event}")
    public Response publishEventWithDatasource(@PathParam(value="event") String event) {
        LOG.infof("publish event %s", (Object)event);
        String response = (String)this.producerTemplate.requestBody("direct:pgevent-datasource", (Object)event, String.class);
        LOG.infof("message received : %s", (Object)response);
        return Response.accepted((Object)response).build();
    }
}

