/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pgevent.it;

import com.impossibl.postgres.jdbc.PGDataSource;
import javax.inject.Named;
import javax.ws.rs.Produces;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.pgevent.it.MyBean;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class PgeventRoutes
extends RouteBuilder {
    @ConfigProperty(name="database.host")
    String host;
    @ConfigProperty(name="database.port")
    Integer port;
    @ConfigProperty(name="database.name")
    String databaseName;
    @ConfigProperty(name="database.user")
    String user;
    @ConfigProperty(name="database.password")
    String password;

    public void configure() throws Exception {
        this.from("direct:pgevent-pub").to("pgevent://{{database.host}}:{{database.port}}/{{database.name}}/testchannel?user={{database.user}}&pass={{database.password}}");
        ((RouteDefinition)this.from("pgevent://{{database.host}}:{{database.port}}/{{database.name}}/testchannel?user={{database.user}}&pass={{database.password}}").log("Message got ${body}")).bean(MyBean.class);
        this.from("direct:pgevent-datasource").to("pgevent:///postgres/testchannel?datasource=#pgDataSource");
        ((RouteDefinition)this.from("pgevent:///postgres/testchannel?datasource=#pgDataSource").log("Message got ${body}")).bean(MyBean.class);
    }

    @Produces
    @Named(value="pgDataSource")
    public PGDataSource loadDataSource() throws Exception {
        PGDataSource dataSource = new PGDataSource();
        dataSource.setHost(this.host);
        dataSource.setPort(this.port.intValue());
        dataSource.setDatabaseName(this.databaseName);
        dataSource.setUser(this.user);
        dataSource.setPassword(this.password);
        return dataSource;
    }
}

