/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pdf.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

@QuarkusTest
class PdfTest {
    PdfTest() {
    }

    @Order(value=1)
    @Test
    public void createFromTextShouldReturnANewPdfDocument() throws IOException {
        byte[] bytes = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("content to be included in the created pdf document").post("/pdf/createFromText", new Object[0])).then()).statusCode(201)).extract().asByteArray();
        PDDocument doc = PDDocument.load((byte[])bytes);
        PDFTextStripper pdfTextStripper = new PDFTextStripper();
        String text = pdfTextStripper.getText(doc);
        Assertions.assertEquals((int)1, (int)doc.getNumberOfPages());
        Assertions.assertTrue((boolean)text.contains("content to be included in the created pdf document"));
        doc.close();
    }

    @Order(value=2)
    @Test
    public void appendTextShouldReturnAnUpdatedPdfDocument() throws IOException {
        byte[] bytes = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("another line that should be appended").put("/pdf/appendText", new Object[0])).then()).statusCode(200)).extract().asByteArray();
        PDDocument doc = PDDocument.load((byte[])bytes);
        PDFTextStripper pdfTextStripper = new PDFTextStripper();
        String text = pdfTextStripper.getText(doc);
        Assertions.assertEquals((int)2, (int)doc.getNumberOfPages());
        Assertions.assertTrue((boolean)text.contains("content to be included in the created pdf document"));
        Assertions.assertTrue((boolean)text.contains("another line that should be appended"));
        doc.close();
    }

    @Order(value=3)
    @Test
    public void extractTextShouldReturnUpdatedText() {
        String pdfText = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/pdf/extractText", (Object[])new Object[0]).then()).statusCode(200)).extract().asString();
        Assertions.assertTrue((boolean)pdfText.contains("content to be included in the created pdf document"));
        Assertions.assertTrue((boolean)pdfText.contains("another line that should be appended"));
    }
}

