/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pdf.it;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.jboss.logging.Logger;

@Path(value="/pdf")
@ApplicationScoped
public class PdfResource {
    private static final Logger LOG = Logger.getLogger(PdfResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    private byte[] document;

    @Path(value="/createFromText")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/octet-stream"})
    public Response createFromText(String message) throws Exception {
        this.document = (byte[])this.producerTemplate.requestBody("pdf:create?fontSize=6&pageSize=PAGE_SIZE_A5&font=Courier", (Object)message, byte[].class);
        LOG.infof("The PDDocument has been created and contains %d bytes", (Object)this.document.length);
        return Response.created((URI)new URI("pdf/extractText")).entity((Object)this.document).build();
    }

    @Path(value="/appendText")
    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"application/octet-stream"})
    public Response appendText(String message) throws Exception {
        this.document = (byte[])this.producerTemplate.requestBodyAndHeader("pdf:append", (Object)message, "pdf-document", (Object)PDDocument.load((byte[])this.document), byte[].class);
        LOG.infof("The PDDocument has been updated and now contains %d bytes", (Object)this.document.length);
        return Response.ok().entity((Object)this.document).build();
    }

    @Path(value="/extractText")
    @GET
    @Produces(value={"text/plain"})
    public String get() throws Exception {
        LOG.info((Object)"Extracting text from the PDDocument");
        return (String)this.producerTemplate.requestBody("pdf:extractText", (Object)PDDocument.load((byte[])this.document), String.class);
    }

    @Path(value="/encrypt/standard")
    @POST
    @Produces(value={"text/plain"})
    public Response encryptStandard(@QueryParam(value="ownerPassword") String ownerPassword, @QueryParam(value="userPassword") String userPassword, String message) throws Exception {
        AccessPermission permission = AccessPermission.getOwnerAccessPermission();
        StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword, permission);
        byte[] document = (byte[])this.producerTemplate.requestBodyAndHeader("pdf:create?fontSize=6&pageSize=PAGE_SIZE_A5&font=Courier", (Object)message, "protection-policy", (Object)policy, byte[].class);
        return Response.created((URI)new URI("pdf/extractText")).entity((Object)document).build();
    }

    @Path(value="/decrypt/standard")
    @POST
    @Produces(value={"text/plain"})
    public Response decryptStandard(@QueryParam(value="password") String password, byte[] rawDocument) throws IOException {
        StandardDecryptionMaterial material = new StandardDecryptionMaterial(password);
        PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(rawDocument), (String)password);
        String result = (String)this.producerTemplate.requestBodyAndHeader("pdf:extractText", (Object)document, "decryption-material", (Object)material, String.class);
        return Response.ok().entity((Object)result).build();
    }
}

