/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.paho.mqtt5.it;

import com.github.dockerjava.api.model.Ulimit;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.quarkus.component.paho.mqtt5.it.InjectPahoContainer;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.apache.camel.util.CollectionHelper;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class PahoMqtt5TestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PahoMqtt5TestResource.class);
    private static final String IMAGE = (String)ConfigProvider.getConfig().getValue("eclipse-mosquitto.container.image", String.class);
    private static final int TCP_PORT = 1883;
    private static final int SSL_PORT = 8883;
    private static final int WS_PORT = 9001;
    private static final String MQTT_USERNAME = "quarkus";
    private static final String MQTT_PASSWORD = "quarkus";
    private GenericContainer<?> container;
    private boolean useFixedPort = false;
    private boolean startContainer = true;

    public void init(Map<String, String> initArgs) {
        initArgs.forEach((name, value) -> {
            if (name.equals("useFixedPort")) {
                this.useFixedPort = Boolean.parseBoolean(value);
            } else if (name.equals("startContainer")) {
                this.startContainer = Boolean.parseBoolean(value);
            }
        });
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields(this.container, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(InjectPahoContainer.class, GenericContainer.class));
    }

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            Map result = new HashMap();
            if (this.useFixedPort) {
                int port = AvailablePortFinder.getNextAvailable();
                this.container = new FixedHostPortGenericContainer(IMAGE).withFixedExposedPort(port, 1883);
                result = CollectionHelper.mapOf((Object)"paho5.broker.tcp.url", (Object)("tcp://" + this.container.getHost() + ":" + port), (Object[])new Object[0]);
            } else {
                this.container = new GenericContainer(IMAGE).withExposedPorts(new Integer[]{1883, 9001, 8883}).withClasspathResourceMapping("mosquitto.conf", "/mosquitto/config/mosquitto.conf", BindMode.READ_ONLY).withClasspathResourceMapping("password.conf", "/etc/mosquitto/password", BindMode.READ_ONLY).withClasspathResourceMapping("certs/ca.pem", "/etc/mosquitto/certs/ca.pem", BindMode.READ_ONLY).withClasspathResourceMapping("certs/server.pem", "/etc/mosquitto/certs/server.pem", BindMode.READ_ONLY).withClasspathResourceMapping("certs/server.key", "/etc/mosquitto/certs/server.key", BindMode.READ_ONLY);
            }
            this.container.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".* mosquitto version .* running.*", (int)1)).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withUlimits(new Ulimit[]{new Ulimit("nofile", 512L, 512L)}));
            if (this.startContainer) {
                this.container.start();
            }
            if (!this.useFixedPort) {
                result = CollectionHelper.mapOf((Object)"camel.component.paho-mqtt5.username", (Object)"quarkus", (Object[])new Object[]{"camel.component.paho-mqtt5.password", "quarkus", "paho5.broker.host", this.container.getHost(), "paho5.broker.tcp.url", String.format("tcp://%s:%d", this.container.getHost(), this.container.getMappedPort(1883)), "paho5.broker.ssl.url", String.format("ssl://%s:%d", this.container.getHost(), this.container.getMappedPort(8883)), "paho5.broker.ws.url", String.format("ws://%s:%d", this.container.getHost(), this.container.getMappedPort(9001))});
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

