/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.paho.mqtt5.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.paho.mqtt5.it.PahoMqtt5TestResource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource(value=PahoMqtt5TestResource.class)
class PahoMqtt5Test {
    PahoMqtt5Test() {
    }

    @ParameterizedTest
    @ValueSource(strings={"tcp", "ssl", "ws"})
    public void sendReceive(String protocol) {
        String message = "Hello Camel Quarkus " + protocol;
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/paho-mqtt5/{protocol}/{queueName}", new Object[]{protocol, protocol + "-test-queue"})).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/paho-mqtt5/{protocol}/{queueName}", new Object[]{protocol, protocol + "-test-queue"})).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
    }

    @Test
    public void overrideTopic() {
        String message = "Hello Camel Quarkus Override Topic";
        String queue = "myoverride";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/paho-mqtt5/override/" + queue, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/paho-mqtt5/tcp/" + queue, new Object[0])).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
    }

    @Test
    public void readThenWriteWithFilePersistenceShouldSucceed() {
        String message = "readThenWriteWithFilePersistenceShouldSucceed message content: 762e6af1-3ec7-40e0-9271-0c98a1001728";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("message", new Object[]{message}).get("/paho-mqtt5/readThenWriteWithFilePersistenceShouldSucceed", new Object[0])).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
    }
}

