/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.paho.mqtt5.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.ConfigProvider;

@Path(value="/paho-mqtt5")
@ApplicationScoped
public class PahoMqtt5Resource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/{protocol}/{queueName}")
    @GET
    @Produces(value={"text/plain"})
    public String consumePahoMessage(@PathParam(value="protocol") String protocol, @PathParam(value="queueName") String queueName) {
        return (String)this.consumerTemplate.receiveBody("paho-mqtt5:" + queueName + "?brokerUrl=" + this.brokerUrl(protocol), 5000L, String.class);
    }

    @Path(value="/{protocol}/{queueName}")
    @POST
    @Consumes(value={"text/plain"})
    public Response producePahoMessage(@PathParam(value="protocol") String protocol, @PathParam(value="queueName") String queueName, String message) throws Exception {
        this.producerTemplate.sendBody("paho-mqtt5:" + queueName + "?retained=true&brokerUrl=" + this.brokerUrl(protocol), (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    private String brokerUrl(String protocol) {
        return (String)ConfigProvider.getConfig().getValue("paho5.broker." + protocol + ".url", String.class);
    }
}

