/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.paho.mqtt5.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.paho.mqtt5.it.Counter;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.RoutePolicySupport;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class PahoMqtt5Route
extends RouteBuilder {
    public static final String TESTING_ROUTE_ID = "testingRoute";
    @Inject
    Counter counter;

    public void configure() throws Exception {
        SupervisingRouteController supervising = this.getCamelContext().getRouteController().supervising();
        supervising.setBackOffDelay(200L);
        supervising.setIncludeRoutes("paho-mqtt5:*");
        this.from("direct:test").to("paho-mqtt5:queue?lazyStartProducer=true&brokerUrl=" + this.brokerUrl("tcp"));
        ((RouteDefinition)this.from("paho-mqtt5:queue?brokerUrl=" + this.brokerUrl("tcp")).id(TESTING_ROUTE_ID)).routePolicy(new RoutePolicy[]{new RoutePolicySupport(){

            public void onStart(Route route) {
                PahoMqtt5Route.this.counter.countDown();
            }
        }}).to("mock:test");
    }

    private String brokerUrl(String protocol) {
        return (String)ConfigProvider.getConfig().getValue("paho5.broker." + protocol + ".url", String.class);
    }
}

