/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.paho.mqtt5.it;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.paho.mqtt5.it.Counter;
import org.apache.camel.spi.RouteController;
import org.eclipse.microprofile.config.ConfigProvider;

@Path(value="/paho-mqtt5")
@ApplicationScoped
public class PahoMqtt5Resource {
    @Inject
    CamelContext context;
    @Inject
    Counter counter;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    private final String keystore = "clientkeystore.jks";
    private final String password = "quarkus";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{protocol}/{queueName}")
    @GET
    @Produces(value={"text/plain"})
    public String consumePahoMessage(@PathParam(value="protocol") String protocol, @PathParam(value="queueName") String queueName) {
        String result;
        String tmpKeystore = null;
        Object sslClientProps = "";
        try {
            if ("ssl".equals(protocol)) {
                tmpKeystore = this.setKeyStore("clientkeystore.jks");
                sslClientProps = "&sslClientProps.com.ibm.ssl.keyStore=" + tmpKeystore + "&sslClientProps.com.ibm.ssl.keyStorePassword=quarkus&sslClientProps.com.ibm.ssl.trustStore=" + tmpKeystore + "&sslClientProps.com.ibm.ssl.trustStorePassword=quarkus";
            }
            result = (String)this.consumerTemplate.receiveBody("paho-mqtt5:" + queueName + "?brokerUrl=" + this.brokerUrl(protocol) + (String)sslClientProps, 5000L, String.class);
        }
        finally {
            if ("ssl".equals(protocol) && tmpKeystore != null) {
                this.removeKeyStore(tmpKeystore);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{protocol}/{queueName}")
    @POST
    @Consumes(value={"text/plain"})
    public Response producePahoMessage(@PathParam(value="protocol") String protocol, @PathParam(value="queueName") String queueName, String message) throws Exception {
        String tmpKeystore = null;
        Object sslClientProps = "";
        try {
            if ("ssl".equals(protocol)) {
                tmpKeystore = this.setKeyStore("clientkeystore.jks");
                sslClientProps = "&sslClientProps.com.ibm.ssl.keyStore=" + tmpKeystore + "&sslClientProps.com.ibm.ssl.keyStorePassword=quarkus&sslClientProps.com.ibm.ssl.trustStore=" + tmpKeystore + "&sslClientProps.com.ibm.ssl.trustStorePassword=quarkus";
            }
            this.producerTemplate.sendBody("paho-mqtt5:" + queueName + "?retained=true&brokerUrl=" + this.brokerUrl(protocol) + (String)sslClientProps, (Object)message);
        }
        finally {
            if ("ssl".equals(protocol) && tmpKeystore != null) {
                this.removeKeyStore(tmpKeystore);
            }
        }
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/override/{queueName}")
    @POST
    @Consumes(value={"text/plain"})
    public Response overrideQueueName(@PathParam(value="queueName") String queueName, String message) throws Exception {
        this.producerTemplate.sendBodyAndHeader("paho-mqtt5:test?retained=true&brokerUrl=" + this.brokerUrl("tcp"), (Object)message, "CamelPahoMqtt5OverrideTopic", (Object)queueName);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/readThenWriteWithFilePersistenceShouldSucceed")
    @GET
    @Produces(value={"text/plain"})
    public String readThenWriteWithFilePersistenceShouldSucceed(@QueryParam(value="message") String message) throws Exception {
        this.producerTemplate.sendBody("paho-mqtt5:withFilePersistence?retained=true&persistence=FILE&brokerUrl=" + this.brokerUrl("tcp"), (Object)message);
        return (String)this.consumerTemplate.receiveBody("paho-mqtt5:withFilePersistence?persistence=FILE&brokerUrl=" + this.brokerUrl("tcp"), 5000L, String.class);
    }

    @Path(value="/routeStatus/{id}")
    @GET
    @Produces(value={"text/plain"})
    public String routeStatus(@PathParam(value="id") String routeId, @QueryParam(value="waitForContainerStarted") @DefaultValue(value="false") boolean wait) throws Exception {
        RouteController routeController = this.context.getRouteController();
        if (wait) {
            this.counter.await(30, TimeUnit.SECONDS);
        }
        return routeController.getRouteStatus(routeId).name();
    }

    @Path(value="/mock")
    @POST
    @Produces(value={"text/plain"})
    public String mock(String message) throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:test", MockEndpoint.class);
        endpoint.expectedBodiesReceived(new Object[]{message});
        endpoint.assertIsSatisfied();
        return "OK";
    }

    @Path(value="/send")
    @POST
    @Produces(value={"text/plain"})
    public Response send(String message) throws Exception {
        this.producerTemplate.sendBody("direct:test", (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    private String brokerUrl(String protocol) {
        return (String)ConfigProvider.getConfig().getValue("paho5.broker." + protocol + ".url", String.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String setKeyStore(String keystore) {
        String tmpKeystore = null;
        try {
            try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(keystore);){
                tmpKeystore = File.createTempFile("keystore-", ".jks").getPath();
                Files.copy(in, Paths.get(tmpKeystore, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                return tmpKeystore;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not copy " + keystore + " from the classpath to " + tmpKeystore, e);
            }
        }
        catch (Throwable throwable) {
            return tmpKeystore;
        }
    }

    private void removeKeyStore(String keystore) {
        try {
            Files.delete(Paths.get(keystore, new String[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not delete " + keystore, e);
        }
    }
}

