/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentracing.it;

import io.opentracing.tag.Tags;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class OpenTracingTest {
    OpenTracingTest() {
    }

    @AfterEach
    public void afterEach() {
        ((ValidatableResponse)RestAssured.post((String)"/opentracing/mock/tracer/reset", (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void testTraceRoute() {
        for (int i = 0; i < 5; ++i) {
            ((ValidatableResponse)RestAssured.get((String)"/opentracing/test/trace", (Object[])new Object[0]).then()).statusCode(200);
            ((ValidatableResponse)RestAssured.get((String)"/opentracing/test/trace/filtered", (Object[])new Object[0]).then()).statusCode(200);
        }
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)5, (int)spans.size());
        for (Map<String, String> span : spans) {
            Assertions.assertEquals((Object)"server", (Object)span.get(Tags.SPAN_KIND.getKey()));
            Assertions.assertEquals((Object)"camel-platform-http", (Object)span.get(Tags.COMPONENT.getKey()));
            Assertions.assertEquals((Object)"200", (Object)span.get(Tags.HTTP_STATUS.getKey()));
            Assertions.assertEquals((Object)"GET", (Object)span.get(Tags.HTTP_METHOD.getKey()));
            Assertions.assertEquals((Object)"platform-http:///opentracing/test/trace?httpMethodRestrict=GET", (Object)span.get("camel.uri"));
            Assertions.assertTrue((boolean)span.get(Tags.HTTP_URL.getKey()).endsWith("/opentracing/test/trace"));
        }
    }

    @Test
    public void testTracedBeanInvokedFromRoute() {
        ((ValidatableResponse)RestAssured.get((String)"/opentracing/test/bean", (Object[])new Object[0]).then()).statusCode(200);
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)2, (int)spans.size());
        Assertions.assertEquals((Object)spans.get(0).get("parentId"), (Object)spans.get(1).get("spanId"));
        Assertions.assertEquals((Object)0, (Object)spans.get(1).get("parentId"));
        Assertions.assertEquals((Object)"camel-platform-http", (Object)spans.get(1).get(Tags.COMPONENT.getKey()));
    }

    @Test
    public void testTracedCamelRouteInvokedFromJaxRsService() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/opentracing/trace", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Traced direct:start"), new Matcher[0]);
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)3, (int)spans.size());
        Assertions.assertEquals((Object)spans.get(0).get("parentId"), (Object)spans.get(1).get("spanId"));
        Assertions.assertEquals((Object)spans.get(1).get("parentId"), (Object)spans.get(2).get("spanId"));
        Assertions.assertEquals((Object)0, (Object)spans.get(2).get("parentId"));
        Assertions.assertEquals((Object)"jaxrs", (Object)spans.get(2).get(Tags.COMPONENT.getKey()));
    }

    private List<Map<String, String>> getSpans() {
        return (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/opentracing/spans", new Object[0])).then()).statusCode(200)).extract().body().jsonPath().get();
    }
}

