/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentracing.it;

import io.opentracing.Span;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.opentracing.OpenTracingSpanAdapter;
import org.apache.camel.quarkus.component.opentracing.it.TracedBean;
import org.apache.camel.tracing.ActiveSpanManager;

@ApplicationScoped
public class OpenTracingRouteBuilder
extends RouteBuilder {
    @Inject
    TracedBean tracedBean;

    public void configure() throws Exception {
        ((RouteDefinition)this.from("platform-http:/opentracing/test/trace?httpMethodRestrict=GET").setHeader("CamelHttpResponseCode", (Expression)this.constant(200))).setBody((Expression)this.constant("GET: /opentracing/test/trace"));
        this.from("platform-http:/opentracing/test/trace/filtered").setBody((Expression)this.constant("GET: /opentracing/test/trace/filtered"));
        ((RouteDefinition)this.from("platform-http:/opentracing/test/bean").process(exchange -> {
            Span span = this.getCurrentSpan(exchange);
            this.tracedBean.doTrace(span);
        })).setHeader("CamelHttpResponseCode", (Expression)this.constant(200));
        ((RouteDefinition)this.from("direct:start").process(exchange -> {
            Span span = this.getCurrentSpan(exchange);
            this.tracedBean.doTrace(span);
        })).setBody().constant((Object)"Traced direct:start");
    }

    private Span getCurrentSpan(Exchange exchange) {
        OpenTracingSpanAdapter adapter = (OpenTracingSpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
        return adapter.getOpenTracingSpan();
    }
}

