/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentracing.it;

import io.opentracing.Tracer;
import io.opentracing.mock.MockSpan;
import io.opentracing.mock.MockTracer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.opentracing.Traced;

@Path(value="/opentracing")
@ApplicationScoped
@Traced(value=false)
public class OpenTracingResource {
    @Inject
    Tracer tracer;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/spans")
    @GET
    @Produces(value={"application/json"})
    public JsonArray getSpans() {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        MockTracer mockTracer = (MockTracer)this.tracer;
        for (MockSpan span : mockTracer.finishedSpans()) {
            MockSpan.MockContext context = span.context();
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            objectBuilder.add("spanId", context.spanId());
            objectBuilder.add("traceId", context.traceId());
            objectBuilder.add("parentId", span.parentId());
            span.tags().forEach((k, v) -> objectBuilder.add(k, v.toString()));
            arrayBuilder.add((JsonValue)objectBuilder.build());
        }
        return arrayBuilder.build();
    }

    @Traced
    @Path(value="/trace")
    @GET
    @Produces(value={"text/plain"})
    public String traceRoute() {
        return (String)this.producerTemplate.requestBody("direct:start", null, String.class);
    }

    @Path(value="/mock/tracer/reset")
    @POST
    public void resetMockTracer() {
        MockTracer mockTracer = (MockTracer)this.tracer;
        mockTracer.reset();
    }
}

