/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentracing.it;

import io.opentracing.tag.Tags;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class OpenTracingTest {
    OpenTracingTest() {
    }

    @Test
    public void testTraceRoute() {
        for (int i = 0; i < 5; ++i) {
            ((ValidatableResponse)RestAssured.get((String)"/opentracing/test/trace", (Object[])new Object[0]).then()).statusCode(200);
            ((ValidatableResponse)RestAssured.get((String)"/opentracing/test/trace/filtered", (Object[])new Object[0]).then()).statusCode(200);
        }
        JsonPath jsonPath = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/opentracing/spans", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        List spans = (List)jsonPath.get();
        Assertions.assertEquals((int)5, (int)spans.size());
        for (Map span : spans) {
            Assertions.assertEquals((Object)"server", span.get(Tags.SPAN_KIND.getKey()));
            Assertions.assertEquals((Object)"camel-platform-http", span.get(Tags.COMPONENT.getKey()));
            Assertions.assertEquals((Object)"200", span.get(Tags.HTTP_STATUS.getKey()));
            Assertions.assertEquals((Object)"GET", span.get(Tags.HTTP_METHOD.getKey()));
            Assertions.assertEquals((Object)"platform-http:///opentracing/test/trace?httpMethodRestrict=GET", span.get("camel.uri"));
            Assertions.assertTrue((boolean)((String)span.get(Tags.HTTP_URL.getKey())).endsWith("/opentracing/test/trace"));
        }
    }
}

