/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentelemetry.it;

import io.opentelemetry.api.trace.SpanKind;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.opentelemetry.it.OpenTelemetryTestResource;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTestResource(value=OpenTelemetryTestResource.class)
@QuarkusTest
class OpenTelemetryTest {
    OpenTelemetryTest() {
    }

    @AfterEach
    public void afterEach() {
        ((ValidatableResponse)RestAssured.post((String)"/opentelemetry/exporter/spans/reset", (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void testTraceRoute() {
        for (int i = 0; i < 5; ++i) {
            ((ValidatableResponse)RestAssured.get((String)"/opentelemetry/test/trace/", (Object[])new Object[0]).then()).statusCode(200);
        }
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollDelay(50L, TimeUnit.MILLISECONDS).until(() -> this.getSpans().size() == 5);
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)5, (int)spans.size());
        for (Map<String, String> span : spans) {
            Assertions.assertEquals((Object)"camel-platform-http", (Object)span.get("component"));
            Assertions.assertEquals((Object)"200", (Object)span.get("http.status_code"));
            Assertions.assertEquals((Object)"GET", (Object)span.get("http.method"));
            Assertions.assertEquals((Object)"platform-http:///opentelemetry/test/trace?httpMethodRestrict=GET", (Object)span.get("camel.uri"));
            Assertions.assertTrue((boolean)span.get("http.url").endsWith("/opentelemetry/test/trace/"));
        }
    }

    @Test
    public void testTracedCamelRouteInvokedFromJaxRsService() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/opentelemetry/trace", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Traced direct:start"), new Matcher[0]);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollDelay(50L, TimeUnit.MILLISECONDS).until(() -> this.getSpans().size() == 3);
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)3, (int)spans.size());
        Assertions.assertEquals((Object)spans.get(0).get("parentId"), (Object)spans.get(1).get("spanId"));
        Assertions.assertEquals((Object)spans.get(1).get("kind"), (Object)SpanKind.CLIENT.name());
        Assertions.assertEquals((Object)spans.get(2).get("kind"), (Object)SpanKind.SERVER.name());
    }

    @Test
    public void testTracedBean() {
        String name = "Camel Quarkus OpenTelemetry";
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/opentelemetry/greet/" + name), (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)("Hello " + name)), new Matcher[0]);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollDelay(50L, TimeUnit.MILLISECONDS).until(() -> this.getSpans().size() == 4);
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)4, (int)spans.size());
        Assertions.assertEquals((Object)spans.get(0).get("parentId"), (Object)spans.get(1).get("parentId"));
        Assertions.assertEquals((Object)spans.get(1).get("parentId"), (Object)spans.get(2).get("spanId"));
        Assertions.assertEquals((Object)spans.get(2).get("kind"), (Object)SpanKind.CLIENT.name());
        Assertions.assertEquals((Object)spans.get(3).get("kind"), (Object)SpanKind.SERVER.name());
    }

    @Test
    public void testTracedJdbcQuery() {
        String timestamp = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/opentelemetry/jdbc/query", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((Long.parseLong(timestamp) > 0L ? 1 : 0) != 0);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollDelay(50L, TimeUnit.MILLISECONDS).until(() -> this.getSpans().size() == 6);
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)6, (int)spans.size());
        Assertions.assertEquals((Object)spans.get(0).get("parentId"), (Object)spans.get(1).get("parentId"));
        Assertions.assertEquals((Object)spans.get(0).get("code.function"), (Object)"getConnection");
        Assertions.assertEquals((Object)spans.get(1).get("parentId"), (Object)spans.get(2).get("spanId"));
        Assertions.assertEquals((Object)spans.get(1).get("db.operation"), (Object)"SELECT");
        Assertions.assertEquals((Object)spans.get(2).get("parentId"), (Object)spans.get(3).get("spanId"));
        Assertions.assertEquals((Object)spans.get(2).get("camel.uri"), (Object)"bean://jdbcQueryBean");
        Assertions.assertEquals((Object)spans.get(3).get("parentId"), (Object)spans.get(4).get("spanId"));
        Assertions.assertEquals((Object)spans.get(3).get("camel.uri"), (Object)"direct://jdbcQuery");
        Assertions.assertEquals((Object)spans.get(4).get("parentId"), (Object)spans.get(5).get("spanId"));
        Assertions.assertEquals((Object)spans.get(4).get("camel.uri"), (Object)"direct://jdbcQuery");
        Assertions.assertEquals((Object)spans.get(5).get("parentId"), (Object)"0000000000000000");
        Assertions.assertEquals((Object)spans.get(5).get("code.function"), (Object)"jdbcQuery");
    }

    private List<Map<String, String>> getSpans() {
        return (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/opentelemetry/exporter/spans", new Object[0])).then()).statusCode(200)).extract().body().jsonPath().get();
    }
}

