/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentelemetry.it;

import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.data.SpanData;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;

@Path(value="/opentelemetry/exporter")
public class SpanExporterResource {
    @Inject
    InMemorySpanExporter exporter;

    @Path(value="/spans")
    @GET
    @Produces(value={"application/json"})
    public JsonArray getSpans() {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (SpanData span : this.exporter.getFinishedSpanItems()) {
            if (span.getName().contains("exporter")) continue;
            Map attributes = span.getAttributes().asMap();
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            objectBuilder.add("spanId", span.getSpanId());
            objectBuilder.add("traceId", span.getTraceId());
            objectBuilder.add("parentId", span.getParentSpanId());
            objectBuilder.add("kind", span.getKind().name());
            attributes.forEach((k, v) -> objectBuilder.add(String.valueOf(k), v.toString()));
            arrayBuilder.add((JsonValue)objectBuilder.build());
        }
        return arrayBuilder.build();
    }

    @POST
    @Path(value="/spans/reset")
    public void resetSpanExporter() {
        this.exporter.reset();
    }
}

