/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentelemetry.it;

import io.agroal.api.AgroalDataSource;
import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

@Singleton
@Named(value="jdbcQueryBean")
@RegisterForReflection(fields=false)
public class JdbcQueryBean {
    @Inject
    AgroalDataSource dataSource;

    /*
     * Enabled aggressive exception aggregation
     */
    public long getNowTimestamp() {
        try (Connection connection = this.dataSource.getConnection();){
            long l;
            block18: {
                Statement statement;
                block16: {
                    long l2;
                    block17: {
                        statement = connection.createStatement();
                        try {
                            ResultSet resultSet = statement.executeQuery("SELECT EXTRACT(EPOCH FROM NOW());");
                            if (!resultSet.next()) break block16;
                            l2 = resultSet.getLong(1);
                            if (statement == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        statement.close();
                    }
                    return l2;
                }
                l = 0L;
                if (statement == null) break block18;
                statement.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

