/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentelemetry.it;

import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Map;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/opentelemetry/exporter")
public class SpanExporterResource {
    @Inject
    InMemorySpanExporter exporter;

    @Path(value="/spans")
    @GET
    @Produces(value={"application/json"})
    public JsonArray getSpans() {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (SpanData span : this.exporter.getFinishedSpanItems()) {
            if (span.getName().contains("exporter")) continue;
            Map attributes = span.getAttributes().asMap();
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            objectBuilder.add("spanId", span.getSpanId());
            objectBuilder.add("traceId", span.getTraceId());
            objectBuilder.add("parentId", span.getParentSpanId());
            attributes.forEach((k, v) -> objectBuilder.add(String.valueOf(k), v.toString()));
            arrayBuilder.add((JsonValue)objectBuilder.build());
        }
        return arrayBuilder.build();
    }

    @POST
    @Path(value="/spans/reset")
    public void resetSpanExporter() {
        this.exporter.reset();
    }
}

