/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentelemetry.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class OpenTelemetryTest {
    OpenTelemetryTest() {
    }

    @AfterEach
    public void afterEach() {
        ((ValidatableResponse)RestAssured.post((String)"/opentelemetry/exporter/spans/reset", (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void testTraceRoute() {
        for (int i = 0; i < 5; ++i) {
            ((ValidatableResponse)RestAssured.get((String)"/opentelemetry/test/trace/", (Object[])new Object[0]).then()).statusCode(200);
        }
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)5, (int)spans.size());
        for (Map<String, String> span : spans) {
            Assertions.assertEquals((Object)"camel-platform-http", (Object)span.get("component"));
            Assertions.assertEquals((Object)"200", (Object)span.get("http.status_code"));
            Assertions.assertEquals((Object)"GET", (Object)span.get("http.method"));
            Assertions.assertEquals((Object)"platform-http:///opentelemetry/test/trace?httpMethodRestrict=GET", (Object)span.get("camel.uri"));
            Assertions.assertTrue((boolean)span.get("http.url").endsWith("/opentelemetry/test/trace/"));
        }
    }

    @Test
    public void testTracedCamelRouteInvokedFromJaxRsService() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/opentelemetry/trace", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Traced direct:start"), new Matcher[0]);
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)2, (int)spans.size());
        Assertions.assertEquals((Object)spans.get(0).get("parentId"), (Object)spans.get(1).get("spanId"));
    }

    @Test
    public void testTracedBean() {
        String name = "Camel Quarkus OpenTelemetry";
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/opentelemetry/greet/" + name), (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)("Hello " + name)), new Matcher[0]);
        List<Map<String, String>> spans = this.getSpans();
        Assertions.assertEquals((int)3, (int)spans.size());
        Assertions.assertEquals((Object)spans.get(0).get("parentId"), (Object)spans.get(1).get("parentId"));
        Assertions.assertEquals((Object)spans.get(1).get("parentId"), (Object)spans.get(2).get("spanId"));
    }

    private List<Map<String, String>> getSpans() {
        return (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/opentelemetry/exporter/spans", new Object[0])).then()).statusCode(200)).extract().body().jsonPath().get();
    }
}

