/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.HashMap;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.model.storage.object.SwiftObject;

@Path(value="/openstack/swift/objects/")
@ApplicationScoped
public class OpenstackSwiftObjectResource {
    private static final Logger LOG = Logger.getLogger(OpenstackSwiftObjectResource.class);
    private static final String URI_FORMAT = "openstack-swift://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=objects";
    private static final String OBJECT_CONTAINER_NAME = "test-container";
    private static final String OBJECT_NAME = "test-file";
    @Inject
    ProducerTemplate template;

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackSwiftObjectResource.getShouldSucceed()");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("containerName", OBJECT_CONTAINER_NAME);
        headers.put("objectName", OBJECT_NAME);
        String uri = String.format(URI_FORMAT, "get");
        SwiftObject swiftObject = (SwiftObject)this.template.requestBodyAndHeaders(uri, null, headers, SwiftObject.class);
        Assertions.assertEquals((Object)OBJECT_CONTAINER_NAME, (Object)swiftObject.getContainerName());
        Assertions.assertEquals((Object)OBJECT_NAME, (Object)swiftObject.getName());
        Assertions.assertEquals((long)15L, (long)swiftObject.getSizeInBytes());
        Assertions.assertEquals((Object)"application/json", (Object)swiftObject.getMimeType());
        Assertions.assertEquals((Object)"12345678901234567890", (Object)swiftObject.getETag());
    }
}

